/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.client.gui.widget;

import growthcraft.core.shared.client.gui.widget.WidgetIconBase;
import growthcraft.core.shared.client.gui.widget.WidgetManager;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;

public class WidgetDeviceProgressIcon
extends WidgetIconBase {
    public ProgressDirection progressDirection = ProgressDirection.LEFT_TO_RIGHT;

    public WidgetDeviceProgressIcon(WidgetManager man, int x, int y, int w, int h) {
        super(man, x, y, w, h);
    }

    public WidgetDeviceProgressIcon setProgressDirection(ProgressDirection dir) {
        this.progressDirection = dir;
        return this;
    }

    @Override
    protected void doDraw(int mx, int my, int x, int y) {
        Object tileEntity = this.manager.gui.getTileEntity();
        if (tileEntity instanceof ITileProgressiveDevice) {
            ITileProgressiveDevice progDevice = (ITileProgressiveDevice)tileEntity;
            int dx = x;
            int dy = y;
            int tx = this.textureRect.x;
            int ty = this.textureRect.y;
            int tw = this.textureRect.w;
            int th = this.textureRect.h;
            switch (this.progressDirection) {
                case LEFT_TO_RIGHT: {
                    tw = progDevice.getDeviceProgressScaled(tw);
                    break;
                }
                case RIGHT_TO_LEFT: {
                    tw = progDevice.getDeviceProgressScaled(tw);
                    int offX = this.textureRect.w - tw;
                    dx += offX;
                    tx += offX;
                    break;
                }
                case TOP_TO_BOTTOM: {
                    th = progDevice.getDeviceProgressScaled(th);
                    break;
                }
                case BOTTOM_TO_TOP: {
                    th = progDevice.getDeviceProgressScaled(th);
                    int offY = this.textureRect.h - th;
                    dy += offY;
                    ty += offY;
                    break;
                }
            }
            if (tw > 0 && th > 0) {
                this.manager.gui.func_73729_b(dx, dy, tx, ty, tw, th);
            }
        }
    }

    public static enum ProgressDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }
}

