/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.block;

import growthcraft.core.shared.block.GrowthcraftBlockContainer;
import growthcraft.core.shared.block.IRotatableBlock;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GrowthcraftRotatableBlockContainer
extends GrowthcraftBlockContainer
implements IRotatableBlock {
    public static final PropertyEnum<EnumFacing> TYPE_ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumFacing.class);

    GrowthcraftRotatableBlockContainer(Material material, MapColor mapColor) {
        super(material, mapColor);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE_ROTATION, (Comparable)EnumFacing.NORTH));
    }

    public GrowthcraftRotatableBlockContainer(Material material) {
        super(material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE_ROTATION, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        if (this.isRotatable((IBlockAccess)world, pos, side)) {
            IBlockState state = world.func_180495_p(pos);
            this.doRotateBlock(world, pos, state, side);
            this.markBlockForUpdate(world, pos);
            return true;
        }
        return false;
    }

    protected void placeBlockByEntityDirection(World world, BlockPos pos, EntityLivingBase entity, ItemStack stack) {
        if (this.isRotatable((IBlockAccess)world, pos, null)) {
            IBlockState state = world.func_180495_p(pos);
            IBlockState newState = state.func_177226_a(TYPE_ROTATION, (Comparable)EnumFacing.func_176733_a((double)entity.field_70177_z));
            world.func_180501_a(pos, newState, 2);
        }
    }

    public void doRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        EnumFacing current;
        EnumFacing newDirection = current = (EnumFacing)state.func_177229_b(TYPE_ROTATION);
        if (current == side) {
            switch (current) {
                case UP: {
                    newDirection = EnumFacing.NORTH;
                    break;
                }
                case DOWN: {
                    newDirection = EnumFacing.SOUTH;
                    break;
                }
                case NORTH: 
                case EAST: {
                    newDirection = EnumFacing.UP;
                    break;
                }
                case SOUTH: 
                case WEST: {
                    newDirection = EnumFacing.DOWN;
                    break;
                }
            }
        } else {
            switch (current) {
                case UP: {
                    newDirection = EnumFacing.DOWN;
                    break;
                }
                case DOWN: {
                    newDirection = EnumFacing.UP;
                    break;
                }
                case WEST: {
                    newDirection = EnumFacing.SOUTH;
                    break;
                }
                case EAST: {
                    newDirection = EnumFacing.NORTH;
                    break;
                }
                case NORTH: {
                    newDirection = EnumFacing.WEST;
                    break;
                }
                case SOUTH: {
                    newDirection = EnumFacing.EAST;
                    break;
                }
            }
        }
        if (newDirection != current) {
            IBlockState newState = state.func_177226_a(TYPE_ROTATION, (Comparable)newDirection);
            world.func_180501_a(pos, newState, 2);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ROTATION});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_ROTATION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(TYPE_ROTATION)).func_176745_a();
    }
}

