/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.block;

import growthcraft.core.shared.utils.HashKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class BlockKey
extends HashKey {
    public final Block block;
    public final int meta;

    public BlockKey(@Nonnull Block pBlock, int pMeta) {
        this.block = pBlock;
        this.meta = pMeta;
        this.generateHashCode();
    }

    public BlockKey(@Nonnull IBlockState pBlockState) {
        this(pBlockState.func_177230_c(), pBlockState.func_177230_c().func_176201_c(pBlockState));
    }

    public BlockKey(@Nonnull Block pBlock) {
        this(pBlock, 0);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMetadata() {
        return this.meta;
    }

    public boolean matches(@Nullable Block pBlock, int pMeta) {
        if (pBlock == null) {
            return false;
        }
        return pBlock == this.block && (this.meta == Short.MAX_VALUE || pMeta == this.meta);
    }

    public boolean matches(@Nonnull BlockKey key) {
        return this.matches(key.getBlock(), key.getMetadata());
    }

    private void generateHashCode() {
        this.hash = this.block.hashCode();
        this.hash = 31 * this.hash + this.meta;
    }
}

