/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.heatsource.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.heatsource.user.UserHeatSourceEntries;
import growthcraft.cellar.shared.processing.heatsource.user.UserHeatSourceEntry;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class UserHeatSourcesConfig
extends AbstractUserJSONConfig {
    private final UserHeatSourceEntries defaultEntries = new UserHeatSourceEntries();
    private UserHeatSourceEntries entries;

    public UserHeatSourceEntry addDefault(String m, String b, Map<Integer, Float> s) {
        UserHeatSourceEntry entry = new UserHeatSourceEntry(m, b, s);
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserHeatSourceEntry addDefault(ResourceLocation registryName, Map<Integer, Float> s) {
        return this.addDefault(registryName.func_110624_b(), registryName.func_110623_a(), s);
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserHeatSourceEntries)this.gson.fromJson((Reader)buff, UserHeatSourceEntries.class);
    }

    private void addHeatSource(UserHeatSourceEntry entry) {
        Block block = Block.func_149684_b((String)(entry.mod_id + ":" + entry.block_name));
        if (block != null) {
            if (entry.states == null || entry.states.size() == 0) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").warn("Block contains invalid states, we will assume a wildcard, but you should probably set this. mod_id='%s' block='%s'", (Object)entry.mod_id, (Object)entry.block_name);
                CellarRegistry.instance().heatSource().addHeatSource(block, Short.MAX_VALUE);
            } else {
                for (Map.Entry<Integer, Float> pair : entry.states.entrySet()) {
                    int key = pair.getKey();
                    if (key < 0) {
                        key = Short.MAX_VALUE;
                    }
                    CellarRegistry.instance().heatSource().addHeatSource(block, key, pair.getValue().floatValue());
                }
            }
        } else {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Block could not be found, and will not be added as heat source. mod_id='%s' block='%s'", (Object)entry.mod_id, (Object)entry.block_name);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Registering %d heat sources.", (Object)this.entries.data.size());
                for (UserHeatSourceEntry entry : this.entries.data) {
                    this.addHeatSource(entry);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Config data is invalid");
            }
        }
    }
}

