/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.fermenting.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.fermenting.user.UserFermentingRecipe;
import growthcraft.cellar.shared.processing.fermenting.user.UserFermentingRecipes;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.core.shared.config.schema.MultiFluidStackSchema;
import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.item.MultiStacksUtil;
import java.io.BufferedReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class UserFermentingRecipesConfig
extends AbstractUserJSONConfig {
    protected UserFermentingRecipes defaultRecipes = new UserFermentingRecipes();
    protected UserFermentingRecipes recipes;

    public void addDefaultSchemas(ItemKeySchema item, @Nonnull MultiFluidStackSchema inputFluid, @Nonnull FluidStackSchema outputFluid, int time) {
        this.addDefault(new UserFermentingRecipe(item, inputFluid, outputFluid, time));
    }

    public void addDefault(@Nonnull UserFermentingRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("We have a problem here, someone tossed a null user recipe at us!");
            throw new IllegalArgumentException("Oh no you didn't, FIX DAT.");
        }
        this.defaultRecipes.data.add(recipe);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding default user fermenting recipe {%s}", (Object)recipe);
    }

    public void addDefault(@Nonnull Object stack, @Nonnull Object inputFluid, @Nonnull FluidStack outputFluid, int time) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefaultSchemas(itemKey, new MultiFluidStackSchema(MultiStacksUtil.toMultiFluidStacks(inputFluid)), new FluidStackSchema(outputFluid), time);
        }
    }

    public void addFallbackDefault(@Nonnull Object inputFluid, @Nonnull FluidStack outputFluid, int time) {
        this.addDefaultSchemas(null, new MultiFluidStackSchema(MultiStacksUtil.toMultiFluidStacks(inputFluid)), new FluidStackSchema(outputFluid), time);
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserFermentingRecipes)this.gson.fromJson((Reader)reader, UserFermentingRecipes.class);
    }

    private void addRecipe(UserFermentingRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipe is invalid!");
            return;
        }
        if (recipe.item != null && !recipe.item.isValid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipe item is invalid! {%s}", (Object)recipe);
            return;
        }
        if (recipe.input_fluid == null || !recipe.input_fluid.isValid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipe input_fluid is invalid! {%s}", (Object)recipe);
            return;
        }
        if (recipe.output_fluid == null || !recipe.output_fluid.isValid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipe output_fluid is invalid! {%s}", (Object)recipe);
            return;
        }
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding Fermenting Recipe {%s}", (Object)recipe);
        if (recipe.item != null) {
            for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
                for (IMultiFluidStacks inputFluid : recipe.input_fluid.getMultiFluidStacks()) {
                    CellarRegistry.instance().fermenting().addRecipe(recipe.output_fluid.asFluidStack(), inputFluid, item, recipe.time);
                }
            }
        } else {
            for (IMultiFluidStacks inputFluid : recipe.input_fluid.getMultiFluidStacks()) {
                CellarRegistry.instance().fermenting().addFallbackRecipe(recipe.output_fluid.asFluidStack(), inputFluid, recipe.time);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Registering %d fermenting recipes.", (Object)this.recipes.data.size());
                for (UserFermentingRecipe recipe : this.recipes.data) {
                    this.addRecipe(recipe);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Fermenting Recipes data is invalid!");
            }
        }
    }
}

