/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.brewing.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.config.schema.ResidueSchema;
import growthcraft.cellar.shared.processing.brewing.user.UserBrewingRecipe;
import growthcraft.cellar.shared.processing.brewing.user.UserBrewingRecipes;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.core.shared.definition.IMultiItemStacks;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraftforge.fluids.FluidStack;

public class UserBrewingRecipesConfig
extends AbstractUserJSONConfig {
    private final UserBrewingRecipes defaultRecipes = new UserBrewingRecipes();
    private UserBrewingRecipes recipes;

    public void addDefault(UserBrewingRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added new default brewing recipe={%s}", (Object)recipe);
    }

    public void addDefault(Object stack, FluidStack inp, FluidStack out, boolean requiresLid, Residue residue, int time) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefault(new UserBrewingRecipe(itemKey, new FluidStackSchema(inp), new FluidStackSchema(out), requiresLid, residue == null ? null : new ResidueSchema(residue), time));
        }
    }

    public void addFallbackDefault(FluidStack inp, FluidStack out, Residue residue, int time) {
        this.addDefault(new UserBrewingRecipe(null, new FluidStackSchema(inp), new FluidStackSchema(out), null, residue == null ? null : new ResidueSchema(residue), time));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserBrewingRecipes)this.gson.fromJson((Reader)reader, UserBrewingRecipes.class);
    }

    private void addBrewingRecipe(UserBrewingRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid recipe");
            return;
        }
        if (recipe.item != null && recipe.item.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid item for recipe {%s}", (Object)recipe);
            return;
        }
        if (recipe.item == null ^ recipe.requiresLid == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("requiresLib must be null if and only if recipe {%s} is a fallback recipe.", (Object)recipe);
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid input_fluid {%s}", (Object)recipe);
            return;
        }
        if (recipe.output_fluid == null || recipe.output_fluid.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid output_fluid {%s}", (Object)recipe);
            return;
        }
        Residue residue = null;
        if (recipe.residue != null && (residue = recipe.residue.asResidue()) == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Not a valid residue found for {%s}", (Object)recipe);
            return;
        }
        FluidStack inputFluidStack = recipe.input_fluid.asFluidStack();
        FluidStack outputFluidStack = recipe.output_fluid.asFluidStack();
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding user brewing recipe {%s}", (Object)recipe);
        if (recipe.item != null) {
            for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
                CellarRegistry.instance().brewing().addRecipe(inputFluidStack, item, outputFluidStack, recipe.requiresLid, recipe.time, residue);
            }
        } else {
            CellarRegistry.instance().brewing().addFallbackRecipe(inputFluidStack, outputFluidStack, recipe.time, residue);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding %d user brewing recipes.", (Object)this.recipes.data.size());
                for (UserBrewingRecipe recipe : this.recipes.data) {
                    this.addBrewingRecipe(recipe);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipes data is invalid!");
            }
        }
    }
}

