/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.utils;

import growthcraft.core.shared.fluids.IFluidTanks;
import growthcraft.core.shared.utils.BBox;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidRenderUtils {
    public static RenderedFluid getActualFluidBBoxForMax(BBox maxFluidBBox, IFluidTanks tanks) {
        int slotToRender = -1;
        double fluidHeight = -1.0;
        int numTanks = tanks.getTankCount();
        for (int i = 0; i < numTanks; ++i) {
            float f;
            if (!tanks.isFluidTankFilled(i) || !(fluidHeight < (double)(f = (float)tanks.getFluidAmount(i) / (float)tanks.getFluidTank(i).getCapacity()))) continue;
            slotToRender = i;
            fluidHeight = f;
        }
        fluidHeight *= maxFluidBBox.h();
        fluidHeight = FluidRenderUtils.roundToPixel(fluidHeight);
        if (slotToRender == -1 || fluidHeight <= 0.0) {
            fluidHeight = 0.0;
        }
        BBox fluidBBox = new BBox(maxFluidBBox.x0(), maxFluidBBox.y0(), maxFluidBBox.z0(), maxFluidBBox.x1(), maxFluidBBox.y0() + fluidHeight, maxFluidBBox.z1());
        FluidTank tank = slotToRender != -1 ? tanks.getFluidTank(slotToRender) : null;
        return new RenderedFluid(tanks, slotToRender, tank, fluidBBox);
    }

    private static double roundToPixel(double fluidHeight) {
        return (double)MathHelper.func_76128_c((double)(fluidHeight * 16.0 + 0.5)) / 16.0;
    }

    public static class RenderedFluid {
        private final IFluidTanks tanks;
        private final int renderedTankSlot;
        private final FluidTank renderedTank;
        private final BBox fluidBBox;

        public RenderedFluid(IFluidTanks tanks, int renderedTankSlot, FluidTank renderedTank, BBox fluidBBox) {
            this.tanks = tanks;
            this.renderedTankSlot = renderedTankSlot;
            this.renderedTank = renderedTank;
            this.fluidBBox = fluidBBox;
        }

        public IFluidTanks getTanks() {
            return this.tanks;
        }

        public int getRenderedTankSlot() {
            return this.renderedTankSlot;
        }

        public FluidTank getRenderedTank() {
            return this.renderedTank;
        }

        public BBox getFluidBBox() {
            return this.fluidBBox;
        }

        public boolean isNone() {
            return this.renderedTank == null;
        }

        public FluidStack getFluidStack() {
            if (this.renderedTank == null) {
                return null;
            }
            return this.renderedTank.getFluid();
        }
    }
}

