/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.particle.emitter;

import growthcraft.core.shared.client.utils.FXHelper;
import growthcraft.core.shared.utils.Pair;
import growthcraft.core.shared.utils.PulseStepper;
import growthcraft.core.shared.utils.SpatialRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BrewKettleLidSteamEmitter {
    private PulseStepper animPulsar = new PulseStepper(5, 8);
    private SpatialRandom sprand = new SpatialRandom();
    private Pair<Double, Double> steamEmitPos = null;

    public void update(World world, BlockPos pos) {
        PulseStepper.State pulseState = this.animPulsar.update();
        if (pulseState == PulseStepper.State.NONE || this.steamEmitPos == null) {
            if (world.field_73012_v.nextInt(20) >= 19) {
                this.steamEmitPos = this.sprand.nextCenteredD2();
                this.animPulsar.reset();
            }
        } else if (pulseState == PulseStepper.State.PULSE && world.field_73012_v.nextInt(10) >= 3) {
            Pair<Double, Double> p = this.sprand.nextCenteredD2();
            p = new Pair<Double, Double>((Double)this.steamEmitPos.left + (Double)p.left * 0.5, (Double)this.steamEmitPos.right + (Double)p.right * 0.5);
            double horDist = Math.sqrt((Double)p.left * (Double)p.left + (Double)p.right * (Double)p.right);
            p = Math.abs(horDist) >= 1.0E-5 ? new Pair<Double, Double>((Double)p.left / horDist, (Double)p.right / horDist) : new Pair<Double, Double>(1.0, 0.0);
            double maxHorDist = Math.max(Math.abs((Double)p.left), Math.abs((Double)p.right));
            Pair<Double, Double> pMax = new Pair<Double, Double>((Double)p.left / maxHorDist, (Double)p.right / maxHorDist);
            double vel = (0.125 + 0.1 * world.field_73012_v.nextDouble()) * 0.0625;
            double px = (double)pos.func_177958_n() + 0.5 + (Double)pMax.left * 0.5;
            double py = (double)pos.func_177956_o() + 1.0;
            double pz = (double)pos.func_177952_p() + 0.5 + (Double)pMax.right * 0.5;
            double vx = (Double)p.left * vel;
            double vy = vel;
            double vz = (Double)p.right * vel;
            FXHelper.emitSteam(world, px, py, pz, vx, vy, vz);
        }
    }
}

