/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.lib.config;

import growthcraft.bees.common.lib.config.GenericFlowerBlockEntry;
import growthcraft.bees.common.lib.config.IFlowerBlockEntry;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.block.BlockKey;
import growthcraft.core.shared.item.ItemKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BeesRegistry {
    private static final BeesRegistry INSTANCE = new BeesRegistry();
    private final List<ItemKey> beesList = new ArrayList<ItemKey>();
    private final Map<ItemKey, ItemStack> emptyToFullHoneyComb = new HashMap<ItemKey, ItemStack>();
    private final Map<ItemKey, ItemStack> fullToEmptyHoneyComb = new HashMap<ItemKey, ItemStack>();
    private final Map<BlockKey, IFlowerBlockEntry> flowerEntries = new HashMap<BlockKey, IFlowerBlockEntry>();

    public static final BeesRegistry instance() {
        return INSTANCE;
    }

    private ItemKey stackToKey(@Nonnull ItemStack itemstack) {
        return new ItemKey(itemstack);
    }

    public void addBee(@Nonnull Item bee, int meta) {
        GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding Bee {%s}:%d", (Object)bee, (Object)meta);
        this.beesList.add(new ItemKey(bee, meta));
    }

    public void addBee(@Nonnull Block bee, int meta) {
        this.addBee(Item.func_150898_a((Block)bee), meta);
    }

    public void addBee(@Nonnull IBlockState beeState) {
        Block block = beeState.func_177230_c();
        this.addBee(Item.func_150898_a((Block)block), block.func_176201_c(beeState));
    }

    public void addBee(@Nonnull ItemStack stack) {
        ItemKey key = this.stackToKey(stack);
        GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding Bee {%s}", (Object)key);
        this.beesList.add(key);
    }

    public void addBee(@Nonnull Item bee) {
        this.addBee(bee, Short.MAX_VALUE);
    }

    public void addBee(@Nonnull Block bee) {
        this.addBee(Item.func_150898_a((Block)bee), Short.MAX_VALUE);
    }

    protected void addHoneyCombMapping(@Nonnull ItemStack empty, @Nonnull ItemStack full) {
        GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding Honey Comb mapping {%s} - {%s}", (Object)empty, (Object)full);
        this.emptyToFullHoneyComb.put(this.stackToKey(empty), full);
        this.fullToEmptyHoneyComb.put(this.stackToKey(full), empty);
    }

    public void addHoneyComb(@Nonnull ItemStack empty, @Nonnull ItemStack full) {
        this.addHoneyCombMapping(empty, full);
    }

    public ItemStack getFilledHoneyComb(@Nonnull ItemStack itemstack) {
        return this.emptyToFullHoneyComb.get(this.stackToKey(itemstack));
    }

    public ItemStack getEmptyHoneyComb(@Nonnull ItemStack itemstack) {
        return this.fullToEmptyHoneyComb.get(this.stackToKey(itemstack));
    }

    protected boolean isItemFilledHoneyComb(@Nonnull ItemKey key) {
        return this.fullToEmptyHoneyComb.containsKey(key);
    }

    public boolean isItemFilledHoneyComb(@Nonnull ItemStack itemstack) {
        return this.isItemFilledHoneyComb(this.stackToKey(itemstack));
    }

    protected boolean isItemEmptyHoneyComb(@Nonnull ItemKey key) {
        return this.emptyToFullHoneyComb.containsKey(key);
    }

    public boolean isItemEmptyHoneyComb(@Nonnull ItemStack itemstack) {
        return this.isItemEmptyHoneyComb(this.stackToKey(itemstack));
    }

    public boolean isItemHoneyComb(@Nonnull ItemStack itemstack) {
        ItemKey key = this.stackToKey(itemstack);
        return this.isItemFilledHoneyComb(key) || this.isItemEmptyHoneyComb(key);
    }

    public void addFlower(@Nonnull BlockKey key, @Nonnull IFlowerBlockEntry entry) {
        GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding Flower {%s}:{%s}", (Object)key, (Object)entry);
        this.flowerEntries.put(key, entry);
    }

    public void addFlower(@Nonnull IFlowerBlockEntry entry) {
        this.addFlower(new BlockKey(entry.getBlockState()), entry);
    }

    public void addFlower(@Nonnull Block flower, int meta) {
        this.addFlower(new BlockKey(flower, meta), new GenericFlowerBlockEntry(flower, meta));
    }

    public void addFlower(@Nonnull Block flower) {
        this.addFlower(flower, Short.MAX_VALUE);
    }

    public void addFlower(@Nonnull IBlockState flower) {
        this.addFlower(new BlockKey(flower), new GenericFlowerBlockEntry(flower));
    }

    public boolean isItemBee(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        int meta = itemstack.func_77952_i();
        for (ItemKey key : this.beesList) {
            if (item != key.item || key.meta != Short.MAX_VALUE && key.meta != meta) continue;
            return true;
        }
        return false;
    }

    public IFlowerBlockEntry getFlowerBlockEntry(@Nonnull BlockKey key) {
        return this.flowerEntries.get(key);
    }

    public IFlowerBlockEntry getFlowerBlockEntry(@Nullable Block block, int meta) {
        if (block == null) {
            return null;
        }
        IFlowerBlockEntry entry = this.getFlowerBlockEntry(new BlockKey(block, meta));
        if (entry != null) {
            return entry;
        }
        return this.getFlowerBlockEntry(new BlockKey(block, Short.MAX_VALUE));
    }

    public IFlowerBlockEntry getFlowerBlockEntry(@Nullable IBlockState blockState) {
        if (blockState == null) {
            return null;
        }
        Block block = blockState.func_177230_c();
        return this.getFlowerBlockEntry(block, block.func_176201_c(blockState));
    }

    public boolean isBlockFlower(@Nullable IBlockState blockState) {
        return this.flowerEntries.containsKey(new BlockKey(blockState)) || this.flowerEntries.containsKey(new BlockKey(blockState.func_177230_c(), Short.MAX_VALUE));
    }
}

