/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.block;

import growthcraft.apples.common.block.BlockAppleLeaves;
import growthcraft.core.shared.block.ICropDataProvider;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockApple
extends BlockBush
implements ICropDataProvider,
IGrowable,
IPlantable {
    public static final int CHANCE_GROWTH = 10;
    public static final int CHANCE_TO_FALL = 0;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 0.875, 0.625), new AxisAlignedBB(0.3125, 0.5625, 0.3125, 0.6875, 0.875, 0.6875), new AxisAlignedBB(0.25, 0.4375, 0.25, 0.75, 0.875, 0.75)};

    public BlockApple(String unlocalizedName) {
        super(Material.field_151585_k);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_apples", unlocalizedName));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)(this.func_149739_a() + ".tooltip"), (Object[])new Object[0]));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int iAge = this.getAge(state);
        if (iAge <= 3) {
            return BOUNDING_BOXES[0];
        }
        if (iAge > 3 && iAge <= 6) {
            return BOUNDING_BOXES[1];
        }
        return BOUNDING_BOXES[2];
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (worldIn.field_72995_K) {
            return;
        }
        if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(10) == 0 ? 1 : 0) != 0)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.getAge(state) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.getAge(state) < 7;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && this.getAge(state) != 7) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)AGE), 4);
            this.markBlockUpdate(worldIn, pos);
        }
    }

    private void markBlockUpdate(World worldIn, BlockPos pos) {
        worldIn.func_175704_b(pos, pos);
        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
        worldIn.func_180497_b(pos, (Block)this, 0, 0);
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof BlockAppleLeaves;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    private int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getAge(state) == 7) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.getAge(state) == 7) {
            ItemStack appleStack = new ItemStack(Items.field_151034_e, 1);
            return appleStack.func_77973_b();
        }
        return Items.field_190931_a;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, BlockPos pos, IBlockState state) {
        return (float)this.getAge(state) / 7.0f;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.field_151034_e);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }
}

