/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.gravestone.handler;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.subaraki.gravestone.GraveStones;
import net.subaraki.gravestone.common.network.PacketSyncModelToClient;

public class PlayerGraveData
implements IExtendedEntityProperties {
    EntityPlayer player;
    public static final String PROPS = "graveData";
    private int graveID = 1;

    public PlayerGraveData(EntityPlayer player) {
        this.player = player;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(PROPS, (IExtendedEntityProperties)new PlayerGraveData(player));
    }

    public static final PlayerGraveData get(EntityPlayer p) {
        return (PlayerGraveData)p.getExtendedProperties(PROPS);
    }

    public int getGraveModel() {
        return this.graveID;
    }

    public void setGraveModel(int i) {
        this.graveID = i;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("grave_ID", this.graveID);
        if (this.player != null && this.player.field_70170_p.field_72995_K) {
            GraveStones.printDebugMessage("C save " + this.graveID + " ");
        }
        if (this.player != null && !this.player.field_70170_p.field_72995_K) {
            GraveStones.printDebugMessage("S save " + this.graveID + " ");
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.graveID = compound.func_74762_e("grave_ID");
        if (this.player != null && this.player.field_70170_p.field_72995_K) {
            GraveStones.printDebugMessage("C load " + this.graveID + " ");
        }
        if (this.player != null && !this.player.field_70170_p.field_72995_K) {
            GraveStones.printDebugMessage("S load " + this.graveID + " ");
        }
    }

    public void init(Entity entity, World world) {
    }

    public void sync() {
        if (this.player != null && this.player instanceof EntityPlayerMP) {
            GraveStones.instance.network.sendTo((IMessage)new PacketSyncModelToClient(this.graveID), (EntityPlayerMP)this.player);
        }
    }
}

