/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.gravestone.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.subaraki.gravestone.GraveStones;
import net.subaraki.gravestone.client.ClientProxy;
import net.subaraki.gravestone.handler.ConfigHandler;
import net.subaraki.gravestone.handler.PlayerGraveData;
import net.subaraki.gravestone.tileentity.TileEntityGravestone;

public class GravestoneEventHandler {
    public GravestoneEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && PlayerGraveData.get((EntityPlayer)event.entity) != null) {
            PlayerGraveData.get((EntityPlayer)event.entity).sync();
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && PlayerGraveData.get((EntityPlayer)event.entity) == null) {
            PlayerGraveData.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void keyHandling(InputEvent.KeyInputEvent evt) {
        if (ConfigHandler.enableGravesTroughKey && ClientProxy.keyGui.func_151468_f() && Minecraft.func_71410_x().field_71462_r == null) {
            EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
            p.openGui((Object)GraveStones.instance, 1, (World)Minecraft.func_71410_x().field_71441_e, (int)p.field_70165_t, (int)p.field_70163_u, (int)p.field_70161_v);
        }
    }

    @SubscribeEvent
    public void onCloneEvent(PlayerEvent.Clone event) {
        PlayerGraveData dead = PlayerGraveData.get(event.original);
        PlayerGraveData clone = PlayerGraveData.get(event.entityPlayer);
        clone.setGraveModel(dead.getGraveModel());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeathEvent(LivingDeathEvent evt) {
        if (evt.entityLiving instanceof EntityPlayer) {
            int z;
            int y;
            EntityPlayer player = (EntityPlayer)evt.entityLiving;
            if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                return;
            }
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            if (player.field_70170_p.func_147437_c(x, y = MathHelper.func_76128_c((double)player.field_70163_u), z = MathHelper.func_76128_c((double)player.field_70161_v))) {
                if (y < 0) {
                    return;
                }
                while (player.field_70170_p.func_147437_c(x, y, z)) {
                    --y;
                }
            }
            int X = 100;
            int Z = 100;
            int x2 = 0;
            int z2 = 0;
            int dx = 0;
            int dz = -1;
            int t = Math.max(X, Z);
            int maxI = t * t;
            boolean flag = false;
            boolean liquid = false;
            for (int i = 0; i < maxI; ++i) {
                if (-X / 2 <= x2 && x2 <= X / 2 && -Z / 2 <= z2 && z2 <= Z / 2) {
                    int y2 = 0;
                    while (!player.field_70170_p.func_147439_a(x + x2, y + 1 + y2, z + z2).func_149688_o().equals(Material.field_151579_a)) {
                        ++y2;
                    }
                    if (player.field_70170_p.func_147439_a(x + x2, y + y2, z + z2).func_149688_o().func_76224_d()) {
                        GraveStones.printDebugMessage("You were standing in liquid !");
                        --y2;
                        liquid = true;
                    }
                    if (player.field_70170_p.func_147439_a(x + x2, y + y2, z + z2).func_149688_o().func_76220_a() && (player.field_70170_p.func_147439_a(x + x2, y + 1 + y2, z + z2).func_149688_o().equals(Material.field_151579_a) || liquid)) {
                        GraveStones.printDebugMessage("Potential grave at " + (x + x2) + " " + (y + y2) + " " + (z + z2));
                        this.placeGrave(player, x + x2, y + y2, z + z2);
                        flag = true;
                        break;
                    }
                }
                if (x2 == z2 || x2 < 0 && x2 == -z2 || x2 > 0 && x2 == 1 - z2) {
                    t = dx;
                    dx = -dz;
                    dz = t;
                }
                x2 += dx;
                z2 += dz;
            }
            if (!flag && liquid) {
                int y2 = 0;
                while (!player.field_70170_p.func_147439_a(x, y + 1 + y2, z).func_149688_o().equals(Material.field_151579_a)) {
                    ++y2;
                }
                if (player.field_70170_p.func_147439_a(x, y + y2, z).func_149688_o().func_76224_d()) {
                    if (player.field_70170_p.func_147439_a(x, y + 1 + y2, z).func_149688_o().equals(Material.field_151579_a)) {
                        player.field_70170_p.func_147449_b(x, y + y2, z, Blocks.field_150347_e);
                    }
                    this.placeGrave(player, x, y + y2, z);
                }
            } else if (!flag) {
                this.placeGrave(player, x, y, z);
            }
        }
    }

    private void placeGrave(EntityPlayer player, int x, int y, int z) {
        player.field_70170_p.func_147449_b(x, y + 1, z, GraveStones.graveStone);
        TileEntityGravestone te = new TileEntityGravestone();
        InventoryPlayer inv = player.field_71071_by;
        int graveID = PlayerGraveData.get(player).getGraveModel();
        int max = 9;
        if (!ConfigHandler.enableGravesTroughKey) {
            graveID = ConfigHandler.graveOrder[Math.min(player.field_71068_ca / ConfigHandler.graveLevel, max)];
        }
        te.setGraveData(player.func_70005_c_(), graveID);
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack is = inv.func_70301_a(slot);
            if (is == null || slot >= te.func_70302_i_()) continue;
            te.tab = 0;
            te.func_70299_a(slot, is);
            inv.func_70299_a(slot, null);
        }
        this.addOtherInventory(te, player);
        player.field_70170_p.func_147455_a(x, y + 1, z, (TileEntity)te);
        player.field_70170_p.func_147471_g(x, y + 1, z);
        te.func_70296_d();
    }

    private void addOtherInventory(TileEntityGravestone te, EntityPlayer player) {
        int i;
        IInventory inv;
        if (GraveStones.hasRpgI) {
            inv = this.accesInventoryContents(player, "get", "rpgInventory.gui.rpginv.PlayerRpgInventory", "Rpg Inventory");
            if (inv != null) {
                for (i = 0; i < 7; ++i) {
                    ItemStack is;
                    te.list[i + 40] = is = inv.func_70301_a(i);
                    inv.func_70299_a(i, null);
                }
            } else {
                GraveStones.printDebugMessage("GraveStones Mod couldn't connect to Rpg Inventory. Have these classes been modified ? Report to mod Author pleases.");
            }
        }
        if (GraveStones.hasTiCo) {
            ItemStack is;
            IInventory sack = this.accesInventoryContents(player, "getKnapsackInventory ", "tconstruct.armor.player.TPlayerStats", "Tinkers Construct");
            IInventory inv2 = this.accesInventoryContents(player, "getAccessoryInventory ", "tconstruct.armor.player.TPlayerStats", "Tinkers Construct");
            if (sack != null) {
                for (int i2 = 0; i2 < 27; ++i2) {
                    te.list[i2 + 47] = is = sack.func_70301_a(i2);
                    sack.func_70299_a(i2, null);
                }
            } else {
                GraveStones.printDebugMessage("GraveStones Mod couldn't connect to Tinkers Construct's Knapsack. Have these classes been modified ? Report to mod Author pleases.");
            }
            if (inv2 != null) {
                for (int i3 = 0; i3 < 7; ++i3) {
                    te.list[i3 + 74] = is = inv2.func_70301_a(i3);
                    inv2.func_70299_a(i3, null);
                }
            } else {
                GraveStones.printDebugMessage("GraveStones Mod couldn't connect to Tinkers Construct's Armor. Have these classes been modified ? Report to mod Author pleases.");
            }
        }
        if (GraveStones.hasBaub) {
            inv = this.accesInventoryContents(player, "getPlayerBaubles", "baubles.common.lib.PlayerHandler", "Baubles");
            if (inv != null) {
                for (i = 0; i < 4; ++i) {
                    ItemStack is;
                    te.list[i + 81] = is = inv.func_70301_a(i);
                    inv.func_70299_a(i, null);
                }
            } else {
                GraveStones.printDebugMessage("GraveStones Mod couldn't connect to Baubles. Have these classes been modified ? Report to mod Author pleases.");
            }
            try {
                Class<?> clazz = Class.forName("baubles.common.container.InventoryBaubles");
                Method m = clazz.getDeclaredMethod("syncSlotToClients", Integer.TYPE);
                for (int i4 = 0; i4 < 7; ++i4) {
                    m.invoke((Object)inv, i4);
                }
                GraveStones.printDebugMessage("Gravestones was able to access Baubles' save mechanicism ! This print is proof that it got saved correctly.");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (GraveStones.hasGal_Craft) {
            inv = this.accesInventoryContentsStacks(player, "getExtendedInventory", "micdoodle8.mods.galacticraft.core.inventory.InventoryExtended", "GalactiCraft");
            for (i = 0; i < 10; ++i) {
                ItemStack is;
                te.list[i + 85] = is = inv[i];
                inv[i] = null;
            }
        }
        if (GraveStones.hasMari_Cul) {
            inv = this.accesInventoryContentsStacks(player, "getInventory", "mariculture.magic.MirrorHelper", "Mariculture");
            for (i = 0; i < 3; ++i) {
                ItemStack is;
                te.list[i + 95] = is = inv[i];
            }
            try {
                ItemStack[] newstack = new ItemStack[4];
                Class<?> clazz = Class.forName("mariculture.magic.MirrorHelper");
                Method m2 = clazz.getDeclaredMethod("save", EntityPlayer.class, ItemStack[].class);
                Object saveEmptyArray = m2.invoke(null, player, newstack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IInventory accesInventoryContents(EntityPlayer player, String methodName, String path, String modName) {
        try {
            Class<?> clazz = Class.forName(path);
            Method m = clazz.getDeclaredMethod(methodName, EntityPlayer.class);
            Object result = m.invoke(null, player);
            GraveStones.printDebugMessage("Dumping all " + modName + " content into grave");
            return (IInventory)result;
        }
        catch (Exception e) {
            GraveStones.printDebugMessage("Error Encountered trying to acces " + modName + "  Inventory Content. Please report to mod author");
            return null;
        }
    }

    private ItemStack[] accesInventoryContentsStacks(EntityPlayer player, String methodName, String path, String modName) {
        try {
            Class<?> clazz = Class.forName(path);
            Method m = clazz.getDeclaredMethod(methodName, EntityPlayer.class);
            Object result = m.invoke(null, player);
            GraveStones.printDebugMessage("Dumping all " + modName + " content into grave");
            return (ItemStack[])result;
        }
        catch (Exception e) {
            GraveStones.printDebugMessage("Error Encountered trying to acces " + modName + "  Inventory Content. Please report to mod author");
            return null;
        }
    }

    private IInventory accesInventoryContents(EntityPlayer player, String methodName, String path, String declaredField, String modName) {
        try {
            Class<?> clazz = Class.forName(path);
            Method m = clazz.getDeclaredMethod(methodName, EntityPlayer.class);
            Object result = m.invoke(null, player);
            Field f = clazz.getDeclaredField(declaredField);
            IInventory inv = (IInventory)f.get(result);
            GraveStones.printDebugMessage("Dumping all " + modName + " content into grave");
            return inv;
        }
        catch (Exception e) {
            GraveStones.printDebugMessage("Error Encountered trying to acces " + modName + "  Inventory Content. Please report to mod author");
            return null;
        }
    }
}

