/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.gravestone.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.subaraki.gravestone.GraveStones;
import net.subaraki.gravestone.tileentity.TileEntityGravestone;

public class PacketSwitchSlotLayout
implements IMessage {
    public int x;
    public int y;
    public int z;
    public byte graveSlotType;

    public PacketSwitchSlotLayout() {
    }

    public PacketSwitchSlotLayout(int x, int y, int z, byte slotType) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.graveSlotType = slotType;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.graveSlotType = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.graveSlotType);
    }

    public static class PacketSwitchSlotLayoutHandler
    implements IMessageHandler<PacketSwitchSlotLayout, IMessage> {
        public IMessage onMessage(PacketSwitchSlotLayout message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity tile = world.func_147438_o(message.x, message.y, message.z);
            if (tile != null && tile instanceof TileEntityGravestone) {
                TileEntityGravestone grave = (TileEntityGravestone)tile;
                grave.changeSlotLayout(message.graveSlotType);
                grave.tab = message.graveSlotType;
            } else {
                GraveStones.printDebugMessage("Tile Entity did not exist ! Could not acces inventory");
            }
            return null;
        }
    }
}

