/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.potions;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.potions.GRPotions;
import com.theundertaker11.geneticsreborn.potions.ViralAreaEffect;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GREntityPotion
extends EntityPotion {
    double blastRange;
    EnumGenes gene;
    ItemStack potion;
    int delay = 80;

    public GREntityPotion(World worldIn) {
        super(worldIn);
        this.blastRange = GeneticsReborn.virusRange;
    }

    public GREntityPotion(World worldIn, double x, double y, double z, ItemStack potionDamageIn) {
        this(worldIn, x, y, z, GeneticsReborn.virusRange, potionDamageIn);
    }

    public GREntityPotion(World worldIn, double x, double y, double z, double range, ItemStack potionDamageIn) {
        super(worldIn, x, y, z, potionDamageIn);
        this.func_184541_a(potionDamageIn);
        this.potion = potionDamageIn;
        this.blastRange = range;
    }

    public GREntityPotion(World worldIn, EntityLivingBase throwerIn, ItemStack potionDamageIn) {
        super(worldIn, throwerIn, potionDamageIn);
        this.func_184541_a(potionDamageIn);
        this.potion = potionDamageIn;
        this.blastRange = GeneticsReborn.virusRange;
    }

    public void setBlastRange(float r) {
        this.blastRange = r;
    }

    public void setGene(EnumGenes g) {
        this.gene = g;
    }

    public void setDelay(int d) {
        this.delay = d;
    }

    public ItemStack func_184543_l() {
        return this.potion;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184543_l();
            PotionType potiontype = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            if (list.size() > 1 || list.size() > 0 && ((PotionEffect)list.get(0)).func_188419_a() != GRPotions.VIRAL_EFFECT) {
                super.func_70184_a(result);
            }
            if (this.blastRange != 0.0) {
                this.makeAreaOfEffectCloud(itemstack, potiontype);
            }
            this.applySplash(result, list);
            int i = potiontype.func_185172_c() ? 2007 : 2002;
            this.field_70170_p.func_175718_b(i, new BlockPos((Entity)this), PotionUtils.func_190932_c((ItemStack)itemstack));
            this.func_70106_y();
        }
    }

    private void applySplash(RayTraceResult rayTrace, List<PotionEffect> potionEffects) {
        if (this.blastRange > 0.0) {
            AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(this.blastRange, this.blastRange * 0.667, this.blastRange);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
            for (EntityLivingBase entitylivingbase : list) {
                double dist = this.func_70068_e((Entity)entitylivingbase);
                if (!(dist < this.blastRange * this.blastRange)) continue;
                IGenes genes = ModUtils.getIGenes((Entity)entitylivingbase);
                genes.addGene(this.gene);
            }
        } else {
            if (rayTrace.func_178782_a() == BlockPos.field_177992_a) {
                return;
            }
            PotionEffect effect = potionEffects.get(0);
            if (effect.func_188419_a() == GRPotions.GROWTH_EFFECT) {
                this.applyGrowth(rayTrace.func_178782_a());
            }
            if (effect.func_188419_a() == GRPotions.MUTATION_EFFECT) {
                this.applyMutation(rayTrace.func_178782_a());
            }
        }
    }

    private void applyMutation(BlockPos blockPos) {
        Block cursedEarth = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("extrautils2:cursedearth"));
        if (cursedEarth != Blocks.field_150350_a) {
            this.field_70170_p.func_175656_a(blockPos, cursedEarth.func_176223_P());
        }
    }

    private boolean makeGrow(BlockPos pos) {
        IBlockState bs = this.field_70170_p.func_180495_p(pos);
        Block b = bs.func_177230_c();
        if (b instanceof IGrowable) {
            IGrowable g = (IGrowable)b;
            g.func_176474_b(this.field_70170_p, (Random)ThreadLocalRandom.current(), pos, bs);
            return true;
        }
        if (b == Blocks.field_150346_d) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
            return true;
        }
        return false;
    }

    private void applyGrowth(BlockPos pos) {
        Vec3i start = new Vec3i(-4, 0, -4);
        pos.func_177971_a(start);
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                if (this.makeGrow(pos.func_177982_a(x, 0, z)) || this.makeGrow(pos.func_177982_a(x, 1, z))) continue;
                this.makeGrow(pos.func_177982_a(x, -1, z));
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack potionItem, PotionType potion) {
        ViralAreaEffect cloud = new ViralAreaEffect(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        cloud.func_184481_a(this.func_85052_h());
        cloud.func_184483_a((float)this.blastRange);
        cloud.func_184486_b(1800);
        cloud.func_184495_b(0.0f);
        cloud.func_184485_d(this.delay);
        cloud.func_184484_a(potion);
        cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
        cloud.setGene(this.gene);
        NBTTagCompound nbttagcompound = potionItem.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("CustomPotionColor", 99)) {
            cloud.func_184482_a(nbttagcompound.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_72838_d((Entity)cloud);
    }
}

