/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.blocks.BlockBase;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StorageBlockBase
extends BlockBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public StorageBlockBase(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public StorageBlockBase(String name) {
        this(name, Material.field_151573_f, 0.5f, 0.5f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)StorageBlockBase.getFacingFromEntity(pos, placer)), 2);
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entity) {
        return EnumFacing.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)0.0f, (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) != null && tile instanceof GRTileEntityBasicEnergyReceiver) {
            GRTileEntityBasicEnergyReceiver tileentity = (GRTileEntityBasicEnergyReceiver)tile;
            IItemHandler input = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            IItemHandler output = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (!input.getStackInSlot(0).func_190926_b()) {
                ItemStack inputstack = input.getStackInSlot(0);
                EntityItem entityinput = new EntityItem(tileentity.func_145831_w(), (double)tileentity.func_174877_v().func_177958_n(), (double)tileentity.func_174877_v().func_177956_o(), (double)tileentity.func_174877_v().func_177952_p(), inputstack);
                tileentity.func_145831_w().func_72838_d((Entity)entityinput);
            }
            if (!output.getStackInSlot(0).func_190926_b()) {
                ItemStack outputstack = output.getStackInSlot(0);
                EntityItem entityoutput = new EntityItem(tileentity.func_145831_w(), (double)tileentity.func_174877_v().func_177958_n(), (double)tileentity.func_174877_v().func_177956_o(), (double)tileentity.func_174877_v().func_177952_p(), outputstack);
                tileentity.func_145831_w().func_72838_d((Entity)entityoutput);
            }
            if (tileentity.getOverclockerCount() > 0) {
                ItemStack overclockers = new ItemStack(GRItems.Overclocker, tileentity.getOverclockerCount());
                EntityItem entityoverclockers = new EntityItem(tileentity.func_145831_w(), (double)tileentity.func_174877_v().func_177958_n(), (double)tileentity.func_174877_v().func_177956_o(), (double)tileentity.func_174877_v().func_177952_p(), overclockers);
                tileentity.func_145831_w().func_72838_d((Entity)entityoverclockers);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean overclockerOrGUI(World world, BlockPos pos, EntityPlayer player, EnumHand hand, int maxOC, int guiID) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tEntity = world.func_175625_s(pos);
        if (tEntity != null && tEntity instanceof GRTileEntityBasicEnergyReceiver && hand == EnumHand.MAIN_HAND) {
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == GRItems.Overclocker) {
                GRTileEntityBasicEnergyReceiver tile = (GRTileEntityBasicEnergyReceiver)tEntity;
                tile.addOverclocker(player, maxOC);
            } else {
                player.openGui((Object)GeneticsReborn.instance, guiID, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }
}

