/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.items;

import com.mojang.authlib.GameProfile;
import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.Genes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.event.PlayerTickEvent;
import com.theundertaker11.geneticsreborn.items.ItemBase;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GlassSyringe
extends ItemBase {
    public GlassSyringe(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    private static final String getGeneList(NBTTagCompound tag) {
        StringBuffer buf = new StringBuffer();
        buf.append(" (");
        boolean found = false;
        for (int i = 0; i < Genes.TotalNumberOfGenes; ++i) {
            String nbtname = "";
            if (tag.func_74764_b(Integer.toString(i))) {
                nbtname = tag.func_74779_i(Integer.toString(i));
            }
            if ("".equals(nbtname)) continue;
            buf.append(ModUtils.getGeneNameForShow(nbtname)).append(", ");
            found = true;
        }
        if (!found) {
            return "";
        }
        return buf.delete(buf.length() - 2, buf.length()).append(")").toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Right click to draw blood, shift right click to inject blood");
        if (stack.func_77978_p() != null && stack.func_77952_i() == 1) {
            String s = GlassSyringe.getGeneList(stack.func_77978_p());
            if (stack.func_77978_p().func_74767_n("pure")) {
                tooltip.add("This blood is purified" + s);
            } else {
                tooltip.add("This blood is contaminated" + s);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184614_ca();
        if (worldIn.field_72995_K || ModUtils.getIGenes((Entity)playerIn) == null || hand != EnumHand.MAIN_HAND || ModUtils.getIMaxHealth((EntityLivingBase)playerIn) == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound tag = ModUtils.getTagCompound(stack);
        if (!playerIn.func_70093_af() && stack.func_77952_i() == 0) {
            stack.func_77964_b(1);
            playerIn.func_70097_a(DamageSource.field_76377_j, 2.0f);
            tag.func_74757_a("pure", false);
            tag.func_74778_a("owner", EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).toString());
            Genes.setNBTStringsFromGenes(stack, (EntityLivingBase)playerIn);
        } else if (playerIn.func_70093_af()) {
            Boolean configallows = true;
            if (!GeneticsReborn.playerGeneSharing) {
                configallows = tag.func_74779_i("owner").equals(EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).toString());
            }
            if (configallows.booleanValue() && stack.func_77952_i() == 1 && tag.func_74767_n("pure")) {
                stack.func_77964_b(0);
                playerIn.func_70690_d(new PotionEffect(Potion.func_188412_a((int)15), 60, 1));
                playerIn.func_70097_a(DamageSource.field_76377_j, 1.0f);
                IGenes genes = ModUtils.getIGenes((Entity)playerIn);
                tag.func_82580_o("pure");
                tag.func_82580_o("owner");
                for (int i = 0; i < Genes.TotalNumberOfGenes; ++i) {
                    EnumGenes gene;
                    String nbtname = "Null";
                    if (tag.func_74764_b(Integer.toString(i))) {
                        nbtname = tag.func_74779_i(Integer.toString(i));
                        tag.func_82580_o(Integer.toString(i));
                        gene = Genes.getGeneFromString(nbtname);
                        if (gene != null && gene.canAddMutation(genes) && !genes.hasGene(gene)) {
                            genes.addGene(gene);
                        }
                        PlayerTickEvent.geneChanged((EntityLivingBase)playerIn, gene, true);
                    }
                    if (!tag.func_74764_b(i + "anti")) continue;
                    nbtname = tag.func_74779_i(i + "anti");
                    tag.func_82580_o(i + "anti");
                    gene = Genes.getGeneFromString(nbtname);
                    if (gene != null && genes.hasGene(gene)) {
                        genes.removeGene(gene);
                    }
                    PlayerTickEvent.geneChanged((EntityLivingBase)playerIn, gene, false);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

