/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.event;

import com.google.common.collect.HashMultimap;
import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.IMaxHealth;
import com.theundertaker11.geneticsreborn.blocks.GRBlocks;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.packets.ClientGeneChange;
import com.theundertaker11.geneticsreborn.packets.GeneticsRebornPacketHandler;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerTickEvent {
    private static final UUID uuidCybernetic = UUID.fromString("14b60de8-825e-45e1-99c0-51685676f69b");
    private static final HashMultimap<String, AttributeModifier> cyberneticModifierMap = HashMultimap.create();

    @SubscribeEvent
    public void infinityFix(ArrowNockEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        IGenes genes = ModUtils.getIGenes((Entity)player);
        if (EnumGenes.INFINITY.isActive() && genes.hasGene(EnumGenes.INFINITY)) {
            event.getEntityPlayer().func_184598_c(event.getHand());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)event.getBow()));
        }
    }

    @SubscribeEvent
    public void onArrowFire(ArrowLooseEvent event) {
        int punchLevel;
        int powerLevel;
        if (event.hasAmmo()) {
            return;
        }
        World world = event.getEntityPlayer().func_130014_f_();
        ItemStack stack = event.getBow();
        EntityPlayer player = event.getEntityPlayer();
        int charge = event.getCharge();
        float velocity = (float)charge / 20.0f;
        if ((double)(velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (velocity > 1.0f) {
            velocity = 1.0f;
        }
        ItemStack arrowStack = new ItemStack(Items.field_151032_g);
        ItemArrow itemarrow = (ItemArrow)(stack.func_77973_b() instanceof ItemArrow ? arrowStack.func_77973_b() : Items.field_151032_g);
        EntityArrow entityarrow = itemarrow.func_185052_a(world, arrowStack, (EntityLivingBase)player);
        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
        if (velocity == 1.0f) {
            entityarrow.func_70243_d(true);
        }
        if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
            entityarrow.func_70240_a(punchLevel);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            entityarrow.func_70015_d(100);
        }
        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        world.func_72838_d((Entity)entityarrow);
    }

    @SubscribeEvent
    public void onDigSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        IGenes genes = ModUtils.getIGenes((Entity)player);
        if (EnumGenes.EFFICIENCY.isActive()) {
            if (genes.hasGene(EnumGenes.EFFICIENCY_4)) {
                event.setNewSpeed(event.getOriginalSpeed() + 0.25f);
            } else if (genes.hasGene(EnumGenes.EFFICIENCY)) {
                event.setNewSpeed(event.getOriginalSpeed() + 0.15f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        IGenes genes = ModUtils.getIGenes((Entity)player);
        World world = event.player.func_130014_f_();
        if (player == null || genes == null) {
            return;
        }
        if (world.field_72995_K) {
            PlayerTickEvent.checkClimbing(player, world, genes);
        } else {
            if (player.field_70173_aa % 100 == 1) {
                PlayerTickEvent.checkCybernetic(player, world, genes);
                PlayerTickEvent.checkHunger(player, world, genes);
                PlayerTickEvent.tryPhotosynthesis(player, world, genes);
            }
            PlayerTickEvent.tryItemMagnet(player, world, genes);
            PlayerTickEvent.tryXPMagnet(player, world, genes);
        }
    }

    public static void setCyberToleranceUpgrade(float f) {
        cyberneticModifierMap.clear();
        cyberneticModifierMap.put((Object)"cyberware.tolerance", (Object)new AttributeModifier(uuidCybernetic, "Cybernetic gene", (double)f, 0));
    }

    private static void checkCybernetic(EntityPlayer player, World world, IGenes genes) {
        if (!EnumGenes.CYBERNETIC.isActive()) {
            return;
        }
        if (genes.hasGene(EnumGenes.CYBERNETIC)) {
            player.func_110140_aT().func_111147_b(cyberneticModifierMap);
        } else {
            player.func_110140_aT().func_111148_a(cyberneticModifierMap);
        }
    }

    private static void checkClimbing(EntityPlayer player, World world, IGenes genes) {
        if (EnumGenes.CLIMB_WALLS.isActive() && ClientGeneChange.climbingPlayers.contains(player.func_110124_au()) && player.field_70123_F) {
            player.field_70181_x = 0.2;
        }
    }

    private static void changeStepAssist(EntityPlayer player, World world, boolean add) {
        float step_height;
        if (!EnumGenes.STEP_ASSIST.isActive()) {
            return;
        }
        float f = step_height = add ? 1.1f : 0.6f;
        if (player.field_70138_W != step_height) {
            player.field_70138_W = step_height;
            GeneticsRebornPacketHandler.INSTANCE.sendTo((IMessage)new ClientGeneChange(1, step_height), (EntityPlayerMP)player);
        }
    }

    private static void checkHunger(EntityPlayer player, World world, IGenes genes) {
        if (EnumGenes.NO_HUNGER.isActive() && genes.hasGene(EnumGenes.NO_HUNGER) && player.func_71024_bL().func_75116_a() < 5) {
            player.func_71024_bL().func_75114_a(5);
        }
    }

    private static void changeMoreHearts(EntityLivingBase player, World world, boolean add, int amt) {
        if (!EnumGenes.MORE_HEARTS.isActive()) {
            return;
        }
        IMaxHealth hearts = ModUtils.getIMaxHealth(player);
        if (hearts == null) {
            return;
        }
        if (add) {
            hearts.setBonusMaxHealth(hearts.getBonusMaxHealth() + (float)amt);
        }
        if (!add) {
            hearts.setBonusMaxHealth(hearts.getBonusMaxHealth() - (float)amt);
        }
    }

    private static void tryItemMagnet(EntityPlayer player, World world, IGenes genes) {
        if (EnumGenes.ITEM_MAGNET.isActive() && genes.hasGene(EnumGenes.ITEM_MAGNET) && !player.field_71071_by.func_70431_c(new ItemStack(GRItems.AntiField)) && !player.func_70093_af()) {
            for (EntityItem entityItem : ModUtils.getEntitiesInRange(EntityItem.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.5)) {
                if (!entityItem.func_184216_O().contains("geneticsrebornLOL") && PlayerTickEvent.shouldPickupItem(world, entityItem.func_180425_c())) {
                    EntityItemPickupEvent pickupEvent = new EntityItemPickupEvent(player, entityItem);
                    MinecraftForge.EVENT_BUS.post((Event)pickupEvent);
                    ItemStack itemStackToGet = entityItem.func_92059_d();
                    int stackSize = itemStackToGet.func_190916_E();
                    if (pickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && player.field_71071_by.func_70441_a(itemStackToGet)) continue;
                    player.func_71001_a((Entity)entityItem, stackSize);
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue;
                }
                if (entityItem.func_184216_O().contains("geneticsrebornLOL")) continue;
                entityItem.func_184211_a("geneticsrebornLOL");
            }
        }
    }

    private static void tryXPMagnet(EntityPlayer player, World world, IGenes genes) {
        if (EnumGenes.XP_MAGNET.isActive() && genes.hasGene(EnumGenes.XP_MAGNET) && !player.field_71071_by.func_70431_c(new ItemStack(GRItems.AntiField)) && !player.func_70093_af()) {
            for (EntityXPOrb entityXPOrb : ModUtils.getEntitiesInRange(EntityXPOrb.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.5)) {
                if (entityXPOrb.field_70128_L || entityXPOrb.func_82150_aj()) continue;
                player.field_71090_bL = 0;
                entityXPOrb.field_70532_c = 0;
                entityXPOrb.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                PlayerPickupXpEvent xpEvent = new PlayerPickupXpEvent(player, entityXPOrb);
                MinecraftForge.EVENT_BUS.post((Event)xpEvent);
                if (xpEvent.getResult() != Event.Result.ALLOW) continue;
                entityXPOrb.func_70100_b_(player);
            }
        }
    }

    private static void tryPhotosynthesis(EntityPlayer player, World world, IGenes genes) {
        if (EnumGenes.PHOTOSYNTHESIS.isActive() && genes.hasGene(EnumGenes.PHOTOSYNTHESIS) && world.func_72935_r() && world.func_175645_m(player.func_180425_c()).func_177956_o() < player.func_180425_c().func_177956_o() + 1 && ThreadLocalRandom.current().nextInt(100) < 5) {
            player.func_71024_bL().func_75122_a(1, 0.5f);
        }
    }

    public static boolean shouldPickupItem(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = -5; i <= 5; ++i) {
            BlockPos newpos = new BlockPos(x, y + i, z);
            if (world.func_180495_p(newpos).func_177230_c() != GRBlocks.AntiFieldBlock) continue;
            return false;
        }
        return true;
    }

    public static void geneChanged(EntityLivingBase entity, EnumGenes gene, boolean added) {
        World w = entity.field_70170_p;
        if (gene == EnumGenes.MORE_HEARTS) {
            PlayerTickEvent.changeMoreHearts(entity, w, added, 20);
        }
        if (gene == EnumGenes.MORE_HEARTS_2) {
            PlayerTickEvent.changeMoreHearts(entity, w, added, 20 * GeneticsReborn.mutationAmp);
        }
        if (entity instanceof EntityPlayer) {
            if (gene == EnumGenes.STEP_ASSIST) {
                PlayerTickEvent.changeStepAssist((EntityPlayer)entity, w, added);
            }
            if (gene == EnumGenes.CLIMB_WALLS) {
                PlayerTickEvent.changeClimbWalls((EntityPlayer)entity, w, added);
            }
        }
    }

    private static void changeClimbWalls(EntityPlayer entity, World w, boolean added) {
        GeneticsRebornPacketHandler.INSTANCE.sendTo((IMessage)new ClientGeneChange(2, added ? 1.0f : 0.0f), (EntityPlayerMP)entity);
    }
}

