/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.event;

import com.google.common.collect.ImmutableList;
import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.blocks.GRBlocks;
import com.theundertaker11.geneticsreborn.blocks.GRTileEntityLightBlock;
import com.theundertaker11.geneticsreborn.event.GREventHandler;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class OnWorldTickEvent {
    private static List<String> PlayersWithFlight = new ArrayList<String>();

    @SubscribeEvent
    public void WorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.world.field_72995_K) {
            return;
        }
        this.checkFlight(event);
        for (Entity ent : ImmutableList.copyOf((Collection)event.world.field_72996_f)) {
            EntityLivingBase e;
            IGenes genes;
            if (!(ent instanceof EntityLivingBase) || (genes = ModUtils.getIGenes((Entity)(e = (EntityLivingBase)ent))).getGeneNumber() <= 0 || e.field_70128_L) continue;
            OnWorldTickEvent.worldTickGeneLogic(genes, e, event.world);
        }
        OnWorldTickEvent.trackLightBlocks(event.world);
    }

    private void checkFlight(TickEvent.WorldTickEvent event) {
        if (!(!EnumGenes.FLY.isActive() && GeneticsReborn.allowGivingEntityGenes || GREventHandler.flightticktimer <= 30 || event.world.field_72995_K)) {
            GREventHandler.flightticktimer = 0;
            for (EntityPlayerMP player : event.world.func_73046_m().func_184103_al().func_181057_v()) {
                IGenes genes = ModUtils.getIGenes((Entity)player);
                if (player == null || genes == null || player.func_184812_l_()) continue;
                String username = player.func_70005_c_();
                if (genes.hasGene(EnumGenes.FLY)) {
                    boolean shouldFly = true;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack.func_77973_b() != GRItems.AntiField || stack.func_77952_i() != 1) continue;
                        shouldFly = false;
                        if (!player.field_71075_bZ.field_75100_b) break;
                        player.field_71075_bZ.field_75100_b = false;
                        break;
                    }
                    player.field_71075_bZ.field_75101_c = shouldFly;
                    player.func_71016_p();
                    if (PlayersWithFlight.contains(username)) continue;
                    PlayersWithFlight.add(username);
                    continue;
                }
                if (!PlayersWithFlight.contains(username)) continue;
                PlayersWithFlight.remove(username);
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
        }
    }

    private static final void trackLightBlocks(World w) {
        for (EntityLivingBase e : w.func_175644_a(EntityLivingBase.class, EntitySelectors.field_94557_a)) {
            if (!GRTileEntityLightBlock.needsLight(e)) continue;
            BlockPos loc = new BlockPos(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)(e.field_70163_u - 0.2 - e.func_70033_W())), MathHelper.func_76128_c((double)e.field_70161_v)).func_177984_a();
            Block block = w.func_180495_p(loc).func_177230_c();
            if (block == Blocks.field_150350_a) {
                OnWorldTickEvent.placeLightBlock(e, loc);
                continue;
            }
            block = w.func_180495_p(loc = loc.func_177984_a()).func_177230_c();
            if (block != Blocks.field_150350_a) continue;
            OnWorldTickEvent.placeLightBlock(e, loc);
        }
    }

    private static void placeLightBlock(EntityLivingBase entity, BlockPos pos) {
        entity.field_70170_p.func_175656_a(pos, GRBlocks.lightBlock.func_176223_P());
        TileEntity te = entity.field_70170_p.func_175625_s(pos);
        if (te instanceof GRTileEntityLightBlock) {
            GRTileEntityLightBlock teLight = (GRTileEntityLightBlock)te;
            teLight.entity = entity;
        }
    }

    private static void kill(EntityLivingBase e) {
        e.func_70097_a(GeneticsReborn.VIRUS_DAMAGE, Float.MAX_VALUE);
        e.func_70606_j(0.0f);
        e.func_70106_y();
    }

    private static void worldTickGeneLogic(IGenes genes, EntityLivingBase entity, World world) {
        if (world.func_72820_D() % 40L != 0L || genes == null) {
            return;
        }
        long now = world.func_72820_D();
        PotionEffect pe = null;
        int luck = 0;
        boolean potionReset = world.func_72820_D() % 1800L == 1L;
        for (EnumGenes gene : genes.getGeneList()) {
            if (!gene.isActive()) continue;
            switch (gene) {
                case WATER_BREATHING: {
                    entity.func_70050_g(300);
                    break;
                }
                case NIGHT_VISION: {
                    if (!(entity instanceof EntityPlayer)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), 328, 0, false, false));
                    break;
                }
                case JUMP_BOOST: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)8), 110, 1, false, false));
                    break;
                }
                case BLINDNESS: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)15), 2400, 1, false, false));
                    break;
                }
                case CURSED: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)27), 2400, 1, false, false));
                    break;
                }
                case DEAD_ALL: {
                    entity.func_70097_a(GeneticsReborn.VIRUS_DAMAGE, entity.func_110143_aJ() / 2.0f);
                    if (!((double)entity.func_110143_aJ() < 1.1)) break;
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case REALLY_DEAD_ALL: {
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case DEAD_CREEPERS: {
                    if (!(entity instanceof EntityCreeper)) break;
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case DEAD_HOSTILE: {
                    if (!(entity instanceof EntityMob)) break;
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case DEAD_OLD_AGE: {
                    if (!(entity instanceof EntityAgeable)) break;
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case DEAD_UNDEAD: {
                    if (entity.func_70668_bt() != EnumCreatureAttribute.UNDEAD) break;
                    OnWorldTickEvent.kill(entity);
                    break;
                }
                case FLAME: {
                    entity.func_70015_d(120);
                    break;
                }
                case MOB_SIGHT: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)24), 110, 0, false, false));
                    break;
                }
                case HASTE: {
                    if (genes.hasGene(EnumGenes.HASTE_2)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)3), 110, 0, false, false));
                    break;
                }
                case HASTE_2: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)3), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case HUNGER: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)17), 2400, 1, false, false));
                    break;
                }
                case INFINITY: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)14), 110, 0, false, false));
                    break;
                }
                case LAY_EGG: {
                    pe = entity.func_70660_b(Potion.func_188412_a((int)26));
                    int n = luck = pe == null ? 0 : pe.func_76458_c() + 1;
                    if (genes.hasGene(EnumGenes.LAY_EGG) && GREventHandler.isCooldownExpired(entity, "egg", now, true)) {
                        entity.func_145779_a(Items.field_151110_aK, 1 + luck);
                    }
                    if (!genes.hasGene(EnumGenes.LAY_EGG)) break;
                    GREventHandler.addCooldown(entity, "egg", now, 6000 + ThreadLocalRandom.current().nextInt(6000) - luck * 1200);
                    break;
                }
                case LEVITATION: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)25), 2400, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case LUCK: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)26), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case MEATY_2: {
                    pe = entity.func_70660_b(Potion.func_188412_a((int)26));
                    int n = luck = pe == null ? 0 : pe.func_76458_c() + 1;
                    if (genes.hasGene(EnumGenes.MEATY_2) && GREventHandler.isCooldownExpired(entity, "meat", now, true)) {
                        entity.func_145779_a(Items.field_151157_am, 1 + luck);
                    }
                    if (!genes.hasGene(EnumGenes.MEATY_2)) break;
                    GREventHandler.addCooldown(entity, "meat", now, 6000 + ThreadLocalRandom.current().nextInt(6000) - luck * 1200);
                    break;
                }
                case MINING_WEAKNESS: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)4), 2400, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case NAUSEA: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)9), 2400, 1, false, false));
                    break;
                }
                case POISON: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 2400, 1, false, false));
                    break;
                }
                case POISON_4: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 2400, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case REGENERATION: {
                    if (genes.hasGene(EnumGenes.REGENERATION_4)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 110, 0, false, false));
                    break;
                }
                case REGENERATION_4: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case RESISTANCE: {
                    if (genes.hasGene(EnumGenes.RESISTANCE_2)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)11), 110, 0, false, false));
                    break;
                }
                case RESISTANCE_2: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)11), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case SLOWNESS: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 2400, 1, false, false));
                    break;
                }
                case SLOWNESS_4: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 2400, 3 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case SLOWNESS_6: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 2400, 5 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case SPEED: {
                    if (genes.hasGene(EnumGenes.SPEED_4) || genes.hasGene(EnumGenes.SPEED_2)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)1), 110, 0, false, false));
                    break;
                }
                case SPEED_2: {
                    if (genes.hasGene(EnumGenes.SPEED_4)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)1), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case SPEED_4: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)1), 110, GeneticsReborn.mutationAmp * 2, false, false));
                    break;
                }
                case STRENGTH: {
                    if (genes.hasGene(EnumGenes.STRENGTH_2)) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)5), 110, 0, false, false));
                    break;
                }
                case STRENGTH_2: {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)5), 110, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
                case WEAKNESS: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)18), 2400, 1, false, false));
                    break;
                }
                case WITHER: {
                    if (!potionReset) break;
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)20), 2400, 1 + GeneticsReborn.mutationAmp, false, false));
                    break;
                }
            }
        }
    }
}

