/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.integration.lantern;

import com.jaquadro.minecraft.gardenapi.api.component.IRedstoneSource;
import com.jaquadro.minecraft.gardenapi.api.component.StandardLanternSource;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityLantern;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class VanillaLanternSource {

    public static class GlowstoneSource
    extends StandardLanternSource {
        public GlowstoneSource() {
            super(new StandardLanternSource.LanternSourceInfo("glowstone", Items.field_151114_aO, Blocks.field_150426_aN.func_149750_m()));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(RenderBlocks renderer, int x, int y, int z, int meta, int pass) {
            renderer.func_147782_a(0.3, 0.0, 0.3, 0.7, 0.4, 0.7);
            renderer.func_147784_q(Blocks.field_150426_aN, x, y, z);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderItem(RenderBlocks renderer, IItemRenderer.ItemRenderType renderType, int meta) {
            RenderHelper.instance.setRenderBounds(0.3, 0.0, 0.3, 0.7, 0.4, 0.7);
            RenderHelper.instance.renderBlock(null, Blocks.field_150426_aN, 0);
        }
    }

    public static class RedstoneTorchSource
    extends StandardLanternSource
    implements IRedstoneSource {
        public RedstoneTorchSource() {
            super(new StandardLanternSource.LanternSourceInfo("redstoneTorch", Item.func_150898_a((Block)Blocks.field_150429_aA), Blocks.field_150429_aA.func_149750_m()));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(RenderBlocks renderer, int x, int y, int z, int meta, int pass) {
            renderer.func_147769_a(Blocks.field_150429_aA, x, y, z);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderItem(RenderBlocks renderer, IItemRenderer.ItemRenderType renderType, int meta) {
            RenderHelper renderHelper = RenderHelper.instance;
            renderHelper.setRenderBounds(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
            renderHelper.renderFace(2, null, Blocks.field_150429_aA, Blocks.field_150429_aA.func_149691_a(2, 0), meta);
            renderHelper.renderFace(3, null, Blocks.field_150429_aA, Blocks.field_150429_aA.func_149691_a(3, 0), meta);
            renderHelper.setRenderBounds(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
            renderHelper.renderFace(4, null, Blocks.field_150429_aA, Blocks.field_150429_aA.func_149691_a(4, 0), meta);
            renderHelper.renderFace(5, null, Blocks.field_150429_aA, Blocks.field_150429_aA.func_149691_a(5, 0), meta);
            renderHelper.setRenderBounds(0.4375, 0.0, 0.4375, 0.5625, 0.625, 0.5625);
            renderHelper.renderFace(1, null, Blocks.field_150429_aA, Blocks.field_150429_aA.func_149691_a(1, 0), meta);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderParticle(World world, int x, int y, int z, Random rand, int meta) {
            double px = (double)((float)x + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double py = (double)((float)y + 0.6f) + (double)(rand.nextFloat() - 0.5f) * 0.2 + (double)0.1f;
            double pz = (double)((float)z + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", px, py, pz, 0.0, 0.0, 0.0);
        }

        @Override
        public int strongPowerValue(int meta) {
            return 15;
        }

        @Override
        public int weakPowerValue(int meta) {
            return 15;
        }
    }

    public static class TorchLanternSource
    extends StandardLanternSource {
        public TorchLanternSource() {
            super(new StandardLanternSource.LanternSourceInfo("torch", Item.func_150898_a((Block)Blocks.field_150478_aa), Blocks.field_150478_aa.func_149750_m()));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(RenderBlocks renderer, int x, int y, int z, int meta, int pass) {
            renderer.func_147769_a(Blocks.field_150478_aa, x, y, z);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderItem(RenderBlocks renderer, IItemRenderer.ItemRenderType renderType, int meta) {
            RenderHelper renderHelper = RenderHelper.instance;
            renderHelper.setRenderBounds(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
            renderHelper.renderFace(2, null, Blocks.field_150478_aa, Blocks.field_150478_aa.func_149691_a(2, 0), meta);
            renderHelper.renderFace(3, null, Blocks.field_150478_aa, Blocks.field_150478_aa.func_149691_a(3, 0), meta);
            renderHelper.setRenderBounds(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
            renderHelper.renderFace(4, null, Blocks.field_150478_aa, Blocks.field_150478_aa.func_149691_a(4, 0), meta);
            renderHelper.renderFace(5, null, Blocks.field_150478_aa, Blocks.field_150478_aa.func_149691_a(5, 0), meta);
            renderHelper.setRenderBounds(0.4375, 0.0, 0.4375, 0.5625, 0.625, 0.5625);
            renderHelper.renderFace(1, null, Blocks.field_150478_aa, Blocks.field_150478_aa.func_149691_a(1, 0), meta);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderParticle(World world, int x, int y, int z, Random rand, int meta) {
            double px = (float)x + 0.5f;
            double py = (float)y + 0.7f;
            double pz = (float)z + 0.5f;
            TileEntityLantern tile = (TileEntityLantern)world.func_147438_o(x, y, z);
            if (tile == null || !tile.hasGlass()) {
                world.func_72869_a("smoke", px, py, pz, 0.0, 0.0, 0.0);
            }
            world.func_72869_a("flame", px, py, pz, 0.0, 0.0, 0.0);
        }
    }
}

