/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.container;

import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.container.SlotBloomeryOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerBloomeryFurnace
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private TileEntityBloomeryFurnace tileFurnace;
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemBurnTime;
    private Slot primarySlot;
    private Slot secondarySlot;
    private Slot fuelSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerBloomeryFurnace(InventoryPlayer inventory, TileEntityBloomeryFurnace tile) {
        int i;
        this.tileFurnace = tile;
        this.primarySlot = this.func_75146_a(new Slot((IInventory)tile, 0, 56, 17));
        this.secondarySlot = this.func_75146_a(new Slot((IInventory)tile, 1, 35, 17));
        this.fuelSlot = this.func_75146_a(new Slot((IInventory)tile, 2, 56, 53));
        this.outputSlot = this.func_75146_a(new SlotBloomeryOutput(inventory.field_70458_d, (IInventory)tile, 3, 116, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 142)));
        }
    }

    public void func_75132_a(ICrafting crafting) {
        super.func_75132_a(crafting);
        crafting.func_71112_a((Container)this, 0, this.tileFurnace.furnaceCookTime);
        crafting.func_71112_a((Container)this, 1, this.tileFurnace.furnaceBurnTime);
        crafting.func_71112_a((Container)this, 2, this.tileFurnace.currentItemBurnTime);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting crafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastCookTime != this.tileFurnace.furnaceCookTime) {
                crafting.func_71112_a((Container)this, 0, this.tileFurnace.furnaceCookTime);
            }
            if (this.lastBurnTime != this.tileFurnace.furnaceBurnTime) {
                crafting.func_71112_a((Container)this, 1, this.tileFurnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.tileFurnace.currentItemBurnTime) continue;
            crafting.func_71112_a((Container)this, 2, this.tileFurnace.currentItemBurnTime);
        }
        this.lastCookTime = this.tileFurnace.furnaceCookTime;
        this.lastBurnTime = this.tileFurnace.furnaceBurnTime;
        this.lastItemBurnTime = this.tileFurnace.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        switch (id) {
            case 0: {
                this.tileFurnace.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.tileFurnace.furnaceBurnTime = value;
                break;
            }
            case 2: {
                this.tileFurnace.currentItemBurnTime = value;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileFurnace.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slot.func_75220_a(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd) {
                boolean merged = false;
                if (TileEntityBloomeryFurnace.isItemFuel(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.fuelSlot.field_75222_d, this.fuelSlot.field_75222_d + 1, false);
                } else if (TileEntityBloomeryFurnace.isItemPrimaryInput(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.primarySlot.field_75222_d, this.primarySlot.field_75222_d + 1, false);
                } else if (TileEntityBloomeryFurnace.isItemSecondaryInput(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.secondarySlot.field_75222_d, this.secondarySlot.field_75222_d + 1, false);
                }
                if (!merged && (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false))) {
                    return null;
                }
            } else if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == itemStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return itemStack;
    }
}

