/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityLantern
extends TileEntity {
    private boolean hasGlass;
    private String source;
    private int sourceMeta = 0;

    public void setHasGlass(boolean hasGlass) {
        this.hasGlass = hasGlass;
    }

    public boolean hasGlass() {
        return this.hasGlass;
    }

    public void setLightSource(String source) {
        this.source = source;
    }

    public String getLightSource() {
        return this.source;
    }

    public void setLightSourceMeta(int meta) {
        this.sourceMeta = meta;
    }

    public int getLightSourceMeta() {
        return this.sourceMeta;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hasGlass = false;
        this.source = null;
        if (tag.func_74764_b("Glas")) {
            this.hasGlass = tag.func_74767_n("Glas");
        }
        if (tag.func_150297_b("Src", 1)) {
            LightSource[] values = LightSource.values();
            byte index = tag.func_74771_c("Src");
            LightSource legacySource = LightSource.NONE;
            if (index >= 0 && index < values.length) {
                legacySource = values[index];
            }
            switch (legacySource) {
                case TORCH: {
                    this.source = "torch";
                    break;
                }
                case REDSTONE_TORCH: {
                    this.source = "redstoneTorch";
                    break;
                }
                case GLOWSTONE: {
                    this.source = "glowstone";
                    break;
                }
                case FIREFLY: {
                    this.source = "firefly";
                }
            }
        } else if (tag.func_150297_b("Src", 8)) {
            this.source = tag.func_74779_i("Src");
        }
        if (tag.func_74764_b("SrcMeta")) {
            this.sourceMeta = tag.func_74765_d("SrcMeta");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.hasGlass) {
            tag.func_74757_a("Glas", true);
        }
        if (this.source != null) {
            tag.func_74778_a("Src", this.source);
        }
        if (this.sourceMeta != 0) {
            tag.func_74777_a("SrcMeta", (short)this.sourceMeta);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum LightSource {
        NONE,
        TORCH,
        REDSTONE_TORCH,
        GLOWSTONE,
        CANDLE,
        FIREFLY;

    }
}

