/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardencore.api.IPlantProxy;
import com.jaquadro.minecraft.gardencore.api.block.IChain;
import com.jaquadro.minecraft.gardencore.api.block.IChainAttachable;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightChain
extends Block
implements IPlantProxy,
IChain {
    public static final String[] types = new String[]{"iron", "gold", "rope", "rust", "wrought_iron", "moss"};
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] icons;
    private static final Vec3[] defaultAttachPoints;
    private static final Vec3[] singleAttachPoint;

    public BlockLightChain(String blockName) {
        super(Material.field_151573_f);
        this.func_149663_c(blockName);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149676_a(0.4375f, 0.0f, 0.4375f, 0.5625f, 1.0f, 0.5625f);
        this.func_149658_d("GardenStuff:chain_light");
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.lightChainRenderID;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        float minX = 1.0f;
        float minZ = 1.0f;
        float maxX = 0.0f;
        float maxZ = 0.0f;
        for (Vec3 point : this.getAttachPoints((IBlockAccess)world, x, y, z)) {
            if (point.field_72450_a < (double)minX) {
                minX = (float)point.field_72450_a;
            }
            if (point.field_72449_c < (double)minZ) {
                minZ = (float)point.field_72449_c;
            }
            if (point.field_72450_a > (double)maxX) {
                maxX = (float)point.field_72450_a;
            }
            if (!(point.field_72449_c > (double)maxZ)) continue;
            maxZ = (float)point.field_72449_c;
        }
        if ((double)(maxX - minX) < 0.125) {
            minX = 0.4375f;
            maxX = 0.5625f;
        }
        if ((double)(maxZ - minZ) < 0.125) {
            minZ = 0.4375f;
            maxZ = 0.5625f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + minX), (double)(y + 0), (double)((float)z + minZ), (double)((float)x + maxX), (double)(y + 1), (double)((float)z + maxZ));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        BlockGarden block = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            y = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
            return block.applyItemToGarden(world, x, y, z, player, null);
        }
        return super.func_149727_a(world, x, y, z, player, side, vx, vy, vz);
    }

    @Override
    public boolean applyBonemeal(World world, int x, int y, int z) {
        return ModBlocks.gardenProxy.applyBonemeal(world, x, y, z);
    }

    @Override
    public TileEntityGarden getGardenEntity(IBlockAccess blockAccess, int x, int y, int z) {
        return ModBlocks.gardenProxy.getGardenEntity(blockAccess, x, y, z);
    }

    public int findMinY(IBlockAccess world, int x, int y, int z) {
        while (y > 0) {
            if (world.func_147439_a(x, --y, z) == this) continue;
            return y + 1;
        }
        return y;
    }

    public int findMaxY(IBlockAccess world, int x, int y, int z) {
        while (y < world.func_72800_K() - 1) {
            if (world.func_147439_a(x, ++y, z) == this) continue;
            return y - 1;
        }
        return y;
    }

    public Vec3[] getAttachPoints(IBlockAccess world, int x, int y, int z) {
        int yMin = this.findMinY(world, x, y, z);
        Block bottomBlock = world.func_147439_a(x, yMin - 1, z);
        IAttachable attachable = GardenAPI.instance().registries().attachable().getAttachable(bottomBlock, world.func_72805_g(x, y - 1, z));
        Vec3[] attachPoints = singleAttachPoint;
        if (bottomBlock instanceof IChainAttachable) {
            attachPoints = ((IChainAttachable)bottomBlock).getChainAttachPoints(1);
        } else if (attachable != null && attachable.isAttachable(world, x, y - 1, z, 1)) {
            attachPoints = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)attachable.getAttachDepth(world, x, y - 1, z, 1), (double)0.5)};
        } else if (bottomBlock instanceof IChainSingleAttachable) {
            Vec3 attachPoint = ((IChainSingleAttachable)bottomBlock).getChainAttachPoint(world, x, y, z, 1);
            if (attachPoint != null) {
                attachPoints = new Vec3[]{attachPoint};
            }
        } else if (bottomBlock.func_149686_d() && bottomBlock.func_149688_o() != Material.field_151579_a) {
            attachPoints = defaultAttachPoints;
        }
        return attachPoints;
    }

    public int func_149692_a(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)(types.length - 1));
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
    }

    public IIcon func_149691_a(int side, int meta) {
        return icons[MathHelper.func_76125_a((int)meta, (int)0, (int)(types.length - 1))];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        icons = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            BlockLightChain.icons[i] = register.func_94245_a(this.func_149641_N() + "_" + types[i]);
        }
    }

    private int getBaseBlockYCoord(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return 0;
        }
        Block underBlock = world.func_147439_a(x, --y, z);
        while (y > 0 && underBlock instanceof IPlantProxy) {
            underBlock = world.func_147439_a(x, --y, z);
        }
        return y;
    }

    public BlockGarden getGardenBlock(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return null;
        }
        Block underBlock = world.func_147439_a(x, y = this.getBaseBlockYCoord(world, x, y, z), z);
        if (!(underBlock instanceof BlockGarden)) {
            return null;
        }
        return (BlockGarden)underBlock;
    }

    @Override
    public boolean isMultiAttach() {
        return true;
    }

    static {
        defaultAttachPoints = new Vec3[]{Vec3.func_72443_a((double)0.03125, (double)1.0, (double)0.03125), Vec3.func_72443_a((double)0.03125, (double)1.0, (double)0.96875), Vec3.func_72443_a((double)0.96875, (double)1.0, (double)0.03125), Vec3.func_72443_a((double)0.96875, (double)1.0, (double)0.96875)};
        singleAttachPoint = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)1.0, (double)0.5)};
    }
}

