/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardentrees.block.BlockThinLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockConnected
extends Block {
    public BlockConnected(String blockName, Material material) {
        super(material);
        this.func_149663_c(blockName);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149683_g();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        boolean flagN = this.canConnectTo((IBlockAccess)world, x, y, z - 1, ForgeDirection.NORTH);
        boolean flagS = this.canConnectTo((IBlockAccess)world, x, y, z + 1, ForgeDirection.SOUTH);
        boolean flagW = this.canConnectTo((IBlockAccess)world, x - 1, y, z, ForgeDirection.WEST);
        boolean flagE = this.canConnectTo((IBlockAccess)world, x + 1, y, z, ForgeDirection.EAST);
        float height = this.getCollisionHeight();
        if (!(flagW | flagE | flagN | flagS)) {
            this.func_149676_a(0.4375f, 0.0f, 0.4375f, 0.5625f, height, 0.5625f);
            super.func_149743_a(world, x, y, z, mask, list, entity);
            return;
        }
        if (flagW || flagE) {
            if (flagW && flagE) {
                this.func_149676_a(0.0f, 0.0f, 0.4375f, 1.0f, height, 0.5625f);
            } else if (flagW) {
                this.func_149676_a(0.0f, 0.0f, 0.4375f, 0.5f, height, 0.5625f);
            } else if (flagE) {
                this.func_149676_a(0.5f, 0.0f, 0.4375f, 1.0f, height, 0.5625f);
            }
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        if (flagN || flagS) {
            if (flagN && flagS) {
                this.func_149676_a(0.4375f, 0.0f, 0.0f, 0.5625f, height, 1.0f);
            } else if (flagN) {
                this.func_149676_a(0.4375f, 0.0f, 0.0f, 0.5625f, height, 0.5f);
            } else if (flagS) {
                this.func_149676_a(0.4375f, 0.0f, 0.5f, 0.5625f, height, 1.0f);
            }
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
    }

    protected float getCollisionHeight() {
        return 1.0f;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        boolean flagN = this.canConnectTo(world, x, y, z - 1, ForgeDirection.NORTH);
        boolean flagS = this.canConnectTo(world, x, y, z + 1, ForgeDirection.SOUTH);
        boolean flagW = this.canConnectTo(world, x - 1, y, z, ForgeDirection.WEST);
        boolean flagE = this.canConnectTo(world, x + 1, y, z, ForgeDirection.EAST);
        float margin = 0.375f;
        float zs = flagN ? 0.0f : margin;
        float ze = flagS ? 1.0f : 1.0f - margin;
        float xs = flagW ? 0.0f : margin;
        float xe = flagE ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, 0.0f, zs, xe, 1.0f, ze);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return this.canConnectTo(world.func_147439_a(x, y, z)) || world.isSideSolid(x, y, z, dir.getOpposite(), false);
    }

    public boolean canConnectTo(Block block) {
        return block.func_149688_o().func_76218_k() && block.func_149686_d() || block == this;
    }

    public int calcConnectionFlags(IBlockAccess world, int x, int y, int z) {
        Block blockYNeg = world.func_147439_a(x, y - 1, z);
        Block blockYPos = world.func_147439_a(x, y + 1, z);
        Block blockZNeg = world.func_147439_a(x, y, z - 1);
        Block blockZPos = world.func_147439_a(x, y, z + 1);
        Block blockXNeg = world.func_147439_a(x - 1, y, z);
        Block blockXPos = world.func_147439_a(x + 1, y, z);
        boolean hardYNeg = this.isNeighborHardConnection(world, x, y - 1, z, blockYNeg, ForgeDirection.DOWN);
        boolean hardYPos = this.isNeighborHardConnection(world, x, y + 1, z, blockYPos, ForgeDirection.UP);
        boolean hardZNeg = this.isNeighborHardConnection(world, x, y, z - 1, blockZNeg, ForgeDirection.NORTH);
        boolean hardZPos = this.isNeighborHardConnection(world, x, y, z + 1, blockZPos, ForgeDirection.SOUTH);
        boolean hardXNeg = this.isNeighborHardConnection(world, x - 1, y, z, blockXNeg, ForgeDirection.WEST);
        boolean hardXPos = this.isNeighborHardConnection(world, x + 1, y, z, blockXPos, ForgeDirection.EAST);
        boolean extYNeg = this.isNeighborExtConnection(world, x, y - 1, z, blockYNeg, ForgeDirection.DOWN);
        boolean extYPos = this.isNeighborExtConnection(world, x, y + 1, z, blockYPos, ForgeDirection.UP);
        boolean extZNeg = this.isNeighborExtConnection(world, x, y, z - 1, blockZNeg, ForgeDirection.NORTH);
        boolean extZPos = this.isNeighborExtConnection(world, x, y, z + 1, blockZPos, ForgeDirection.SOUTH);
        boolean extXNeg = this.isNeighborExtConnection(world, x - 1, y, z, blockXNeg, ForgeDirection.WEST);
        boolean extXPos = this.isNeighborExtConnection(world, x + 1, y, z, blockXPos, ForgeDirection.EAST);
        return (hardYNeg ? 1 : 0) | (hardYPos ? 2 : 0) | (hardZNeg ? 4 : 0) | (hardZPos ? 8 : 0) | (hardXNeg ? 16 : 0) | (hardXPos ? 32 : 0) | (extYNeg ? 64 : 0) | (extYPos ? 128 : 0) | (extZNeg ? 256 : 0) | (extZPos ? 512 : 0) | (extXNeg ? 1024 : 0) | (extXPos ? 2048 : 0);
    }

    public boolean isFenceBelow(IBlockAccess world, int x, int y, int z) {
        Block blockYNeg = world.func_147439_a(x, y - 1, z);
        return blockYNeg == this;
    }

    private boolean isNeighborHardConnection(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
            return true;
        }
        if (block.isSideSolid(world, x, y, z, side.getOpposite())) {
            return true;
        }
        return block == this;
    }

    private boolean isNeighborExtConnection(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        return block instanceof BlockThinLog;
    }
}

