/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardenstuff.GardenStuff;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import com.jaquadro.minecraft.gardenstuff.core.handlers.GuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBloomeryFurnace
extends BlockContainer {
    private Random random = new Random();
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontLit;

    public BlockBloomeryFurnace(String name) {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(Block.field_149780_i);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149663_c(name);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.bloomeryFurnace);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (!world.field_72995_K) {
            Block neighborZN = world.func_147439_a(x, y, z - 1);
            Block neighborZP = world.func_147439_a(x, y, z + 1);
            Block neighborXN = world.func_147439_a(x - 1, y, z);
            Block neighborXP = world.func_147439_a(x + 1, y, z);
            int direction = 3;
            if (neighborZP.func_149730_j() && !neighborZN.func_149730_j()) {
                direction = 3;
            }
            if (neighborZN.func_149730_j() && !neighborZP.func_149730_j()) {
                direction = 2;
            }
            if (neighborXP.func_149730_j() && !neighborXN.func_149730_j()) {
                direction = 5;
            }
            if (neighborXN.func_149730_j() && !neighborXP.func_149730_j()) {
                direction = 4;
            }
            world.func_72921_c(x, y, z, direction, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.iconBottom;
        }
        if (side == 1) {
            return this.iconTop;
        }
        boolean lit = (meta & 8) > 0;
        int metaDir = meta & 7;
        if (metaDir == 0) {
            metaDir = 3;
        }
        if (metaDir == side) {
            return lit ? this.iconFrontLit : this.field_149761_L;
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("GardenStuff:bloomery_furnace_front_off");
        this.iconFrontLit = register.func_94245_a("GardenStuff:bloomery_furnace_front_on");
        this.iconSide = register.func_94245_a("GardenStuff:bloomery_furnace_side");
        this.iconBottom = register.func_94245_a("GardenStuff:bloomery_furnace_bottom");
        this.iconTop = register.func_94245_a("GardenStuff:bloomery_furnace_top");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBloomeryFurnace tile = (TileEntityBloomeryFurnace)world.func_147438_o(x, y, z);
        if (tile != null) {
            player.openGui((Object)GardenStuff.instance, GuiHandler.bloomeryFurnaceGuiID, world, x, y, z);
        }
        return true;
    }

    public static void updateFurnaceBlockState(World world, int x, int y, int z, boolean lit) {
        int meta = world.func_72805_g(x, y, z);
        int litFlag = lit ? 8 : 0;
        world.func_72921_c(x, y, z, meta & 7 | litFlag, 3);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBloomeryFurnace();
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            return 0;
        }
        return 14;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntityBloomeryFurnace tile;
        int dir = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                world.func_72921_c(x, y, z, 2, 2);
                break;
            }
            case 1: {
                world.func_72921_c(x, y, z, 5, 2);
                break;
            }
            case 2: {
                world.func_72921_c(x, y, z, 3, 2);
                break;
            }
            case 3: {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
        if (stack.func_82837_s() && (tile = (TileEntityBloomeryFurnace)world.func_147438_o(x, y, z)) != null) {
            tile.setCustomName(stack.func_82833_r());
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int side) {
        TileEntityBloomeryFurnace tile = (TileEntityBloomeryFurnace)world.func_147438_o(x, y, z);
        if (tile != null) {
            int n = tile.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack stack = tile.func_70301_a(i);
                if (stack == null) continue;
                float fx = this.random.nextFloat() * 0.8f + 0.1f;
                float fy = this.random.nextFloat() * 0.8f + 0.1f;
                float fz = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int amount = this.random.nextInt(21) + 10;
                    if (amount > stack.field_77994_a) {
                        amount = stack.field_77994_a;
                    }
                    stack.field_77994_a -= amount;
                    EntityItem entity = new EntityItem(world, (double)((float)x + fx), (double)((float)y + fy), (double)((float)z + fz), new ItemStack(stack.func_77973_b(), amount, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    entity.field_70159_w = this.random.nextGaussian() * (double)0.05f;
                    entity.field_70181_x = this.random.nextGaussian() * (double)0.05f + (double)0.2f;
                    entity.field_70179_y = this.random.nextGaussian() * (double)0.05f;
                    world.func_72838_d((Entity)entity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            return;
        }
        int dir = meta & 7;
        float fx = (float)x + 0.5f;
        float fy = (float)y + rand.nextFloat() * 6.0f / 16.0f;
        float fz = (float)z + 0.5f;
        float depth = 0.52f;
        float adjust = rand.nextFloat() * 0.6f - 0.3f;
        switch (dir) {
            case 4: {
                world.func_72869_a("smoke", (double)(fx - depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(fx - depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                world.func_72869_a("smoke", (double)(fx + depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(fx + depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                world.func_72869_a("smoke", (double)(fx + adjust), (double)fy, (double)(fz - depth), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(fx + adjust), (double)fy, (double)(fz - depth), 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                world.func_72869_a("smoke", (double)(fx + adjust), (double)fy, (double)(fz + depth), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(fx + adjust), (double)fy, (double)(fz + depth), 0.0, 0.0, 0.0);
            }
        }
        if (!world.func_147439_a(x, y + 1, z).func_149662_c()) {
            world.func_72869_a("smoke", (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)ModBlocks.bloomeryFurnace);
    }
}

