/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.util;

import com.google.common.base.Objects;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class UniqueMetaIdentifier {
    public final String modId;
    public final String name;
    public final int meta;
    private GameRegistry.UniqueIdentifier cachedUID;

    public UniqueMetaIdentifier(String modId, String name) {
        this.modId = modId;
        this.name = name;
        this.meta = Short.MAX_VALUE;
    }

    public UniqueMetaIdentifier(String modId, String name, int meta) {
        this.modId = modId;
        this.name = name;
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String qualifiedName, int meta) {
        String[] parts = qualifiedName.split(":");
        this.modId = parts[0];
        this.name = parts[1];
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String compoundName) {
        String[] parts1 = compoundName.split(";");
        String[] parts2 = parts1[0].split(":");
        this.modId = parts2[0];
        this.name = parts2.length >= 2 ? parts2[1] : "";
        this.meta = parts1.length >= 2 ? Integer.parseInt(parts1[1]) : (parts2.length > 2 ? Integer.parseInt(parts2[parts2.length - 1]) : Short.MAX_VALUE);
    }

    public UniqueMetaIdentifier(String compoundName, char separator) {
        String[] parts1 = compoundName.split("[ ]*" + separator + "[ ]*");
        String[] parts2 = parts1[0].split(":");
        this.modId = parts2[0];
        this.name = parts2.length >= 2 ? parts2[1] : "";
        this.meta = parts1.length >= 2 ? Integer.parseInt(parts1[1]) : Short.MAX_VALUE;
    }

    public GameRegistry.UniqueIdentifier getUniqueIdentifier() {
        if (this.cachedUID == null) {
            this.cachedUID = new GameRegistry.UniqueIdentifier(this.modId + ":" + this.name);
        }
        return this.cachedUID;
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.modId, (String)this.name);
    }

    public Item getItem() {
        return GameRegistry.findItem((String)this.modId, (String)this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UniqueMetaIdentifier other = (UniqueMetaIdentifier)obj;
        return Objects.equal((Object)this.modId, (Object)other.modId) && Objects.equal((Object)this.name, (Object)other.name) && this.meta == other.meta;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modId, this.name}) ^ this.meta * 37;
    }

    public String toString() {
        return String.format("%s:%s;%d", this.modId, this.name, this.meta);
    }

    public static UniqueMetaIdentifier createFor(ItemStack itemStack) {
        if (itemStack.func_77973_b() == null) {
            return null;
        }
        String name = GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b());
        return new UniqueMetaIdentifier(name, itemStack.func_77960_j());
    }

    public static UniqueMetaIdentifier createFor(Block block, int meta) {
        if (block == null) {
            return null;
        }
        String name = GameData.getBlockRegistry().func_148750_c((Object)block);
        return new UniqueMetaIdentifier(name, meta);
    }

    public static UniqueMetaIdentifier createFor(Block block) {
        if (block == null) {
            return null;
        }
        String name = GameData.getBlockRegistry().func_148750_c((Object)block);
        return new UniqueMetaIdentifier(name);
    }
}

