/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.util;

import net.minecraft.world.World;
import scala.Array;

public class BindingStack {
    private int[] slotStack = new int[16];
    private int[] dataStack = new int[16];
    int index = -1;
    int defaultMeta = 0;

    public void setDefaultMeta(int defaultMeta) {
        this.defaultMeta = defaultMeta;
    }

    public void bind(World world, int x, int y, int z, int slot, int data) {
        if (++this.index >= this.slotStack.length) {
            this.growStack();
        }
        this.slotStack[this.index] = slot;
        this.dataStack[this.index] = data;
        world.func_72921_c(x, y, z, data, 0);
    }

    public void unbind(World world, int x, int y, int z) {
        if (this.index >= 0) {
            --this.index;
        }
        world.func_72921_c(x, y, z, this.getData(), 0);
    }

    public void softUnbind() {
        if (this.index >= 0) {
            --this.index;
        }
    }

    public void refreshWorld(World world, int x, int y, int z) {
        if (this.index >= 0) {
            world.func_72921_c(x, y, z, this.getData(), 0);
        }
    }

    public int getSlot() {
        return this.index >= 0 ? this.slotStack[this.index] : -1;
    }

    public int getData() {
        return this.index >= 0 ? this.dataStack[this.index] : this.defaultMeta;
    }

    private void growStack() {
        int[] newSlotStack = new int[this.slotStack.length * 2];
        int[] newDataStack = new int[this.dataStack.length * 2];
        Array.copy((Object)this.slotStack, (int)0, (Object)newSlotStack, (int)0, (int)this.slotStack.length);
        Array.copy((Object)this.dataStack, (int)0, (Object)newDataStack, (int)0, (int)this.dataStack.length);
        this.slotStack = newSlotStack;
        this.dataStack = newDataStack;
    }
}

