/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.item;

import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ColorizerGrass;

public class ItemUsedSoilKit
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconOverlay;

    public ItemUsedSoilKit(String unlocalizedName) {
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_111206_d("soil_test_kit");
        this.func_77637_a(ModCreativeTabs.tabGardenCore);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 0 ? this.iconOverlay : super.func_77618_c(damage, pass);
    }

    public static int PackTempHumidity(float temp, float humidity) {
        return (int)(humidity * 127.0f) << 7 | (int)(temp * 127.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromDamage(int damage) {
        int temperature = damage & 0x7F;
        int humidity = damage >> 7 & 0x7F;
        return ColorizerGrass.func_77480_a((double)((float)temperature / 255.0f), (double)((float)humidity / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        return pass > 0 ? 0xFFFFFF : this.getColorFromDamage(itemStack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        float temperature = (float)(itemStack.func_77960_j() & 0x7F) / 127.0f;
        float humidity = (float)(itemStack.func_77960_j() >> 7 & 0x7F) / 127.0f;
        EnumChatFormatting tempColor = EnumChatFormatting.BLUE;
        if ((double)temperature >= 0.2) {
            tempColor = EnumChatFormatting.DARK_GREEN;
        }
        if (temperature >= 1.0f) {
            tempColor = EnumChatFormatting.DARK_RED;
        }
        EnumChatFormatting humidColor = EnumChatFormatting.DARK_RED;
        if ((double)humidity >= 0.3) {
            humidColor = EnumChatFormatting.GOLD;
        }
        if ((double)humidity >= 0.6) {
            humidColor = EnumChatFormatting.DARK_GREEN;
        }
        String temperatureStr = StatCollector.func_74838_a((String)"gardencore.soilkit.temperature") + ": " + tempColor + String.format("%.2f", Float.valueOf(temperature));
        String humidityStr = StatCollector.func_74838_a((String)"gardencore.soilkit.rainfall") + ": " + humidColor + String.format("%.2f", Float.valueOf(humidity));
        list.add(temperatureStr);
        list.add(humidityStr);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(0.0f, 0.0f)));
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(0.5f, 0.0f)));
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(1.0f, 0.0f)));
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(0.5f, 0.5f)));
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(1.0f, 0.5f)));
        list.add(new ItemStack(item, 1, ItemUsedSoilKit.PackTempHumidity(1.0f, 1.0f)));
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("GardenCore:soil_test_kit_used");
        this.iconOverlay = iconRegister.func_94245_a("GardenCore:soil_test_kit_overlay");
    }
}

