/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.inventory;

import com.jaquadro.minecraft.gardencore.block.BlockCompostBin;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityCompostBin;
import com.jaquadro.minecraft.gardencore.inventory.SlotCompost;
import com.jaquadro.minecraft.gardencore.inventory.SlotCompostOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerCompostBin
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private TileEntityCompostBin tileCompost;
    private int lastDecompTime;
    private int lastItemDecompTime;
    private int lastDecompCount;
    private Slot outputSlot;
    private List<Slot> compostSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerCompostBin(InventoryPlayer inventory, TileEntityCompostBin tileEntity) {
        int i;
        this.tileCompost = tileEntity;
        this.compostSlots = new ArrayList<Slot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.compostSlots.add(this.func_75146_a(new SlotCompost((IInventory)tileEntity, x + y * 3, 30 + x * 18, 17 + y * 18)));
            }
        }
        this.outputSlot = this.func_75146_a(new SlotCompostOutput(inventory.field_70458_d, (IInventory)tileEntity, 9, 123, 34));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 142)));
        }
    }

    public void func_75132_a(ICrafting crafting) {
        super.func_75132_a(crafting);
        crafting.func_71112_a((Container)this, 0, this.tileCompost.getDecompTime());
        crafting.func_71112_a((Container)this, 1, this.tileCompost.getCurrentItemDecompTime());
        crafting.func_71112_a((Container)this, 2, this.tileCompost.itemDecomposeCount);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting crafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastDecompTime != this.tileCompost.getDecompTime()) {
                crafting.func_71112_a((Container)this, 0, this.tileCompost.getDecompTime());
            }
            if (this.lastItemDecompTime != this.tileCompost.getCurrentItemDecompTime()) {
                crafting.func_71112_a((Container)this, 1, this.tileCompost.getCurrentItemDecompTime());
            }
            if (this.lastDecompCount == this.tileCompost.itemDecomposeCount) continue;
            crafting.func_71112_a((Container)this, 2, this.tileCompost.itemDecomposeCount);
        }
        this.lastDecompTime = this.tileCompost.getDecompTime();
        this.lastItemDecompTime = this.tileCompost.getCurrentItemDecompTime();
        this.lastDecompCount = this.tileCompost.itemDecomposeCount;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.tileCompost.binDecomposeTime = value;
        }
        if (id == 1) {
            this.tileCompost.currentItemDecomposeTime = value;
        }
        if (id == 2) {
            this.tileCompost.itemDecomposeCount = value;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileCompost.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int compostStart = this.compostSlots.get((int)0).field_75222_d;
        int compostEnd = this.compostSlots.get((int)(this.compostSlots.size() - 1)).field_75222_d + 1;
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slot.func_75220_a(slotStack, itemStack);
                BlockCompostBin.updateBlockState(this.tileCompost.func_145831_w(), this.tileCompost.field_145851_c, this.tileCompost.field_145848_d, this.tileCompost.field_145849_e);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd ? (!TileEntityCompostBin.isItemDecomposable(slotStack) || !this.func_75135_a(slotStack, compostStart, compostEnd, false)) && (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false)) : !this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == itemStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return itemStack;
    }
}

