/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.core;

import com.jaquadro.minecraft.gardencore.block.BlockCompostBin;
import com.jaquadro.minecraft.gardencore.block.BlockGardenFarmland;
import com.jaquadro.minecraft.gardencore.block.BlockGardenProxy;
import com.jaquadro.minecraft.gardencore.block.BlockGardenSoil;
import com.jaquadro.minecraft.gardencore.block.BlockSmallFire;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityCompostBin;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGardenFarmland;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGardenSoil;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import org.apache.logging.log4j.Level;

public class ModBlocks {
    public static BlockGardenSoil gardenSoil;
    public static BlockGardenFarmland gardenFarmland;
    public static BlockGardenProxy gardenProxy;
    public static BlockSmallFire smallFire;
    public static BlockCompostBin compostBin;

    public void init() {
        gardenSoil = new BlockGardenSoil(ModBlocks.makeName("gardenSoil"));
        gardenFarmland = new BlockGardenFarmland(ModBlocks.makeName("gardenFarmland"));
        gardenProxy = new BlockGardenProxy(ModBlocks.makeName("gardenProxy"));
        smallFire = new BlockSmallFire(ModBlocks.makeName("smallFire"));
        compostBin = new BlockCompostBin(ModBlocks.makeName("compostBin"));
        GameRegistry.registerBlock((Block)gardenSoil, (String)"garden_soil");
        GameRegistry.registerBlock((Block)gardenFarmland, (String)"garden_farmland");
        GameRegistry.registerBlock((Block)gardenProxy, (String)"garden_proxy");
        GameRegistry.registerBlock((Block)smallFire, (String)"small_fire");
        GameRegistry.registerBlock((Block)compostBin, (String)"compost_bin");
        GameRegistry.registerTileEntity(TileEntityGardenSoil.class, (String)ModBlocks.getQualifiedName((Block)gardenSoil));
        GameRegistry.registerTileEntity(TileEntityGardenFarmland.class, (String)ModBlocks.getQualifiedName((Block)gardenFarmland));
        GameRegistry.registerTileEntity(TileEntityCompostBin.class, (String)ModBlocks.getQualifiedName((Block)compostBin));
    }

    public static String makeName(String name) {
        return "GardenCore".toLowerCase() + "." + name;
    }

    public static Block get(String name) {
        return GameRegistry.findBlock((String)"GardenCore", (String)name);
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    public static UniqueMetaIdentifier getUniqueMetaID(Block block, int meta) {
        String name = GameData.getBlockRegistry().func_148750_c((Object)block);
        if (name == null) {
            FMLLog.log((String)"GardenCore", (Level)Level.WARN, (String)"Tried to make a UniqueMetaIdentifier from an invalid block", (Object[])new Object[0]);
            return null;
        }
        return new UniqueMetaIdentifier(name, meta);
    }
}

