/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.client.renderer;

import com.jaquadro.minecraft.gardencore.api.IPlantMetaResolver;
import com.jaquadro.minecraft.gardencore.api.IPlantRenderer;
import com.jaquadro.minecraft.gardencore.api.PlantRegistry;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.BlockGardenProxy;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;

public class GardenProxyRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockGardenProxy)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockGardenProxy)block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.gardenProxyRenderID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockGardenProxy block, int modelId, RenderBlocks renderer) {
        TileEntityGarden te = block.getGardenEntity(world, x, y, z);
        BlockGarden garden = block.getGardenBlock(world, x, y, z);
        if (te == null || garden == null) {
            return true;
        }
        int section = y - te.field_145848_d;
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block subBlock = block.getPlantBlockRestricted(te, slot);
            int subBlockData = block.getPlantData(te, slot);
            if (subBlock == null) continue;
            block.bindSlot(te.func_145831_w(), x, y, z, te, slot);
            float offsetX = block.getPlantOffsetX(world, x, y, z, slot);
            float offsetY = block.getPlantOffsetY(world, x, y, z, slot);
            float offsetZ = block.getPlantOffsetZ(world, x, y, z, slot);
            AxisAlignedBB[] clippingBounds = garden.getSlotProfile().getClippingBounds(world, x, te.field_145848_d, z, slot);
            int color = subBlock.func_149720_d(world, x, y, z);
            if (color == world.func_72807_a(x, z).func_150558_b(x, y, z)) {
                color = ColorizerGrass.func_77480_a((double)te.getBiomeTemperature(), (double)te.getBiomeHumidity());
            }
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (EntityRenderer.field_78517_a) {
                float gray = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
                float ra = (r * 30.0f + g * 70.0f) / 100.0f;
                float ba = (r * 30.0f + b * 70.0f) / 100.0f;
                r = gray;
                g = ra;
                b = ba;
            }
            tessellator.func_78386_a(r, g, b);
            tessellator.func_78380_c(subBlock.func_149677_c(renderer.field_147845_a, x, y, z));
            tessellator.func_78372_c(offsetX, offsetY, offsetZ);
            try {
                IPlantRenderer plantRenderer = PlantRegistry.instance().getPlantRenderer(subBlock, subBlockData);
                if (plantRenderer != null) {
                    boolean shouldRender;
                    IPlantMetaResolver resolver = PlantRegistry.instance().getPlantMetaResolver(subBlock, subBlockData);
                    boolean bl = shouldRender = section == 1;
                    if (resolver != null && section <= resolver.getPlantHeight(subBlock, subBlockData)) {
                        shouldRender = true;
                    }
                    if (!shouldRender) continue;
                    plantRenderer.render(world, x, y, z, renderer, subBlock, subBlockData, section, clippingBounds);
                    continue;
                }
                renderer.func_147805_b(subBlock, x, y, z);
            }
            catch (Exception e) {
            }
            finally {
                block.unbindSlot(te.func_145831_w(), x, y, z, te);
                tessellator.func_78372_c(-offsetX, -offsetY, -offsetZ);
            }
        }
        return true;
    }

    private boolean renderCrossedSquares(IBlockAccess world, RenderBlocks renderer, Block block, int x, int y, int z, TileEntityGarden te) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        double d1 = x;
        double d2 = y;
        double d0 = z;
        IIcon iicon = renderer.func_147787_a(block, 0, renderer.field_147845_a.func_72805_g(x, y, z));
        renderer.func_147765_a(iicon, d1, d2, d0, 1.0f);
        return true;
    }

    private boolean renderBlockDoublePlant(IBlockAccess world, RenderBlocks renderer, BlockDoublePlant block, int x, int y, int z, TileEntityGarden potData) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        long j1 = (long)(x * 3129871) ^ (long)z * 116129781L;
        j1 = j1 * j1 * 42317861L + j1 * 11L;
        double d19 = x;
        double d0 = y;
        double d1 = z;
        int i1 = renderer.field_147845_a.func_72805_g(x, y, z);
        boolean flag = false;
        boolean flag1 = BlockDoublePlant.func_149887_c((int)i1);
        int k1 = flag1 ? BlockDoublePlant.func_149890_d((int)renderer.field_147845_a.func_72805_g(x, y - 1, z)) : BlockDoublePlant.func_149890_d((int)i1);
        IIcon iicon = block.func_149888_a(flag1, k1);
        renderer.func_147765_a(iicon, d19, d0, d1, 1.0f);
        if (flag1 && k1 == 0) {
            IIcon iicon1 = block.field_149891_b[0];
            double d2 = Math.cos((double)j1 * 0.8) * Math.PI * 0.1;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = iicon1.func_94209_e();
            double d6 = iicon1.func_94206_g();
            double d7 = iicon1.func_94212_f();
            double d8 = iicon1.func_94210_h();
            double d9 = 0.3;
            double d10 = -0.05;
            double d11 = 0.5 + 0.3 * d3 - 0.5 * d4;
            double d12 = 0.5 + 0.5 * d3 + 0.3 * d4;
            double d13 = 0.5 + 0.3 * d3 + 0.5 * d4;
            double d14 = 0.5 + -0.5 * d3 + 0.3 * d4;
            double d15 = 0.5 + -0.05 * d3 + 0.5 * d4;
            double d16 = 0.5 + -0.5 * d3 + -0.05 * d4;
            double d17 = 0.5 + -0.05 * d3 - 0.5 * d4;
            double d18 = 0.5 + 0.5 * d3 + -0.05 * d4;
            tessellator.func_78374_a(d19 + d15, d0 + 1.0, d1 + d16, d5, d8);
            tessellator.func_78374_a(d19 + d17, d0 + 1.0, d1 + d18, d7, d8);
            tessellator.func_78374_a(d19 + d11, d0 + 0.0, d1 + d12, d7, d6);
            tessellator.func_78374_a(d19 + d13, d0 + 0.0, d1 + d14, d5, d6);
            IIcon iicon2 = block.field_149891_b[1];
            d5 = iicon2.func_94209_e();
            d6 = iicon2.func_94206_g();
            d7 = iicon2.func_94212_f();
            d8 = iicon2.func_94210_h();
            tessellator.func_78374_a(d19 + d17, d0 + 1.0, d1 + d18, d5, d8);
            tessellator.func_78374_a(d19 + d15, d0 + 1.0, d1 + d16, d7, d8);
            tessellator.func_78374_a(d19 + d13, d0 + 0.0, d1 + d14, d7, d6);
            tessellator.func_78374_a(d19 + d11, d0 + 0.0, d1 + d12, d5, d6);
        }
        return true;
    }
}

