/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.client.renderer;

import com.jaquadro.minecraft.gardencore.block.BlockCompostBin;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityCompostBin;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class CompostBinRenderer
implements ISimpleBlockRenderingHandler {
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockCompostBin)) {
            return;
        }
        this.renderInventoryBlock((BlockCompostBin)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockCompostBin block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxRenderer.setCutIcon(block.getInnerIcon());
        for (int side = 0; side < 6; ++side) {
            this.boxRenderer.setExteriorIcon(block.func_149691_a(side, metadata), side);
            this.boxRenderer.setInteriorIcon(block.func_149691_a(side, metadata), side);
        }
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0, 2);
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.func_149691_a(1, metadata));
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.125, 0.625, 0.9375, 0.875, 0.75, 1.0, 0, 12);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.125, 0.25, 0.9375, 0.875, 0.375, 1.0, 0, 12);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.125, 0.625, 0.0, 0.875, 0.75, 0.0625, 0, 12);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.125, 0.25, 0.0, 0.875, 0.375, 0.0625, 0, 12);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.9375, 0.625, 0.125, 1.0, 0.75, 0.875, 0, 48);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.9375, 0.25, 0.125, 1.0, 0.375, 0.875, 0, 48);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 0.625, 0.125, 0.0625, 0.75, 0.875, 0, 48);
        this.boxRenderer.renderInterior(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 0.25, 0.125, 0.0625, 0.375, 0.875, 0, 48);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockCompostBin)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockCompostBin)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockCompostBin block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxRenderer.setCutIcon(block.getInnerIcon());
        for (int side = 0; side < 6; ++side) {
            this.boxRenderer.setExteriorIcon(block.func_149673_e(world, x, y, z, side), side);
            this.boxRenderer.setInteriorIcon(block.func_149673_e(world, x, y, z, side), side);
        }
        this.boxRenderer.renderBox(world, (Block)block, x, y, z, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0, 2);
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.func_149673_e(world, x, y, z, 1));
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.125, 0.625, 0.9375, 0.875, 0.75, 1.0, 0, 12);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.125, 0.25, 0.9375, 0.875, 0.375, 1.0, 0, 12);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.125, 0.625, 0.0, 0.875, 0.75, 0.0625, 0, 12);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.125, 0.25, 0.0, 0.875, 0.375, 0.0625, 0, 12);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.9375, 0.625, 0.125, 1.0, 0.75, 0.875, 0, 48);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.9375, 0.25, 0.125, 1.0, 0.375, 0.875, 0, 48);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.0, 0.625, 0.125, 0.0625, 0.75, 0.875, 0, 48);
        this.boxRenderer.renderInterior(world, (Block)block, x, y, z, 0.0, 0.25, 0.125, 0.0625, 0.375, 0.875, 0, 48);
        TileEntityCompostBin te = (TileEntityCompostBin)world.func_147438_o(x, y, z);
        if (te != null) {
            if (te.hasInputItems()) {
                this.boxRenderer.setExteriorIcon(Blocks.field_150346_d.func_149691_a(1, 2));
                this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
            } else if (te.hasOutputItems()) {
                this.boxRenderer.setExteriorIcon(ModBlocks.gardenSoil.func_149691_a(1, 0));
                this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }
}

