/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.tile;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityBlockMateralProxy
extends TileEntity {
    private Block protoBlock;
    private int protoMeta;

    public Block getProtoBlock() {
        return this.protoBlock;
    }

    public int getProtoMeta() {
        return this.protoMeta;
    }

    public void setProtoBlock(Block block, int meta) {
        this.protoBlock = block;
        this.protoMeta = meta;
    }

    public int composeMetadata(Block block, int meta) {
        int id = GameData.getBlockRegistry().getId((Object)block);
        return (id & 0xFFF) << 4 | meta & 0xF;
    }

    public Block getBlockFromComposedMetadata(int metadata) {
        if (metadata >= 16) {
            return (Block)GameData.getBlockRegistry().func_148754_a(metadata >> 4 & 0xFFF);
        }
        return this.getBlockFromStandardMetadata(metadata);
    }

    protected Block getBlockFromStandardMetadata(int metadata) {
        return null;
    }

    public int getMetaFromComposedMetadata(int metadata) {
        if (metadata >= 16) {
            return metadata & 0xF;
        }
        return this.getMetaFromStandardMetadata(metadata);
    }

    protected int getMetaFromStandardMetadata(int metadata) {
        return metadata;
    }

    public void syncTileEntityWithData(World world, int x, int y, int z, int metadata) {
        if (metadata < 16) {
            world.func_147475_p(x, y, z);
            return;
        }
        TileEntityBlockMateralProxy te = (TileEntityBlockMateralProxy)world.func_147438_o(x, y, z);
        if (te == null) {
            te = this.createTileEntity();
            world.func_147455_a(x, y, z, (TileEntity)te);
        }
        Block block = this.getBlockFromComposedMetadata(metadata);
        int protoMeta = this.getMetaFromComposedMetadata(metadata);
        if (block != null) {
            te.setProtoBlock(block, protoMeta);
        }
        te.func_70296_d();
    }

    protected TileEntityBlockMateralProxy createTileEntity() {
        return new TileEntityBlockMateralProxy();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.protoBlock != null) {
            tag.func_74768_a("P", this.getUnifiedProtoData());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("P")) {
            this.unpackUnifiedProtoData(tag.func_74762_e("P"));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int getUnifiedProtoData() {
        return Block.func_149682_b((Block)this.protoBlock) & 0xFFFF | (this.protoMeta & 0xFFFF) << 16;
    }

    private void unpackUnifiedProtoData(int protoData) {
        this.protoBlock = Block.func_149729_e((int)(protoData & 0xFFFF));
        this.protoMeta = protoData >> 16 & 0xFFFF;
    }
}

