/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.support.BasicConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot14ProfileBounded;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare8Profile;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGardenSoil;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGardenSoil
extends BlockGarden {
    private static ItemStack substrate = new ItemStack(Blocks.field_150346_d, 1);

    public BlockGardenSoil(String blockName) {
        super(blockName, Material.field_151578_c);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149779_h);
        PlantType[] commonType = new PlantType[]{PlantType.GROUND, PlantType.AQUATIC, PlantType.AQUATIC_EMERGENT};
        PlantSize[] commonSize = new PlantSize[]{PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        PlantSize[] allSize = new PlantSize[]{PlantSize.FULL, PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        this.connectionProfile = new BasicConnectionProfile();
        this.slotShareProfile = new SlotShare8Profile(6, 7, 8, 9, 10, 11, 12, 13);
        this.slotProfile = new Slot14ProfileBounded(this, new BasicSlotProfile.Slot[]{new BasicSlotProfile.Slot(0, commonType, allSize), new BasicSlotProfile.Slot(1, new PlantType[]{PlantType.GROUND_COVER}, allSize), new BasicSlotProfile.Slot(2, commonType, commonSize), new BasicSlotProfile.Slot(3, commonType, commonSize), new BasicSlotProfile.Slot(4, commonType, commonSize), new BasicSlotProfile.Slot(5, commonType, commonSize), new BasicSlotProfile.Slot(6, commonType, commonSize), new BasicSlotProfile.Slot(7, commonType, commonSize), new BasicSlotProfile.Slot(8, commonType, commonSize), new BasicSlotProfile.Slot(9, commonType, commonSize), new BasicSlotProfile.Slot(10, commonType, commonSize), new BasicSlotProfile.Slot(11, commonType, commonSize), new BasicSlotProfile.Slot(12, commonType, commonSize), new BasicSlotProfile.Slot(13, commonType, commonSize)});
    }

    @Override
    public TileEntityGardenSoil createNewTileEntity(World var1, int var2) {
        return new TileEntityGardenSoil();
    }

    @Override
    public ItemStack getGardenSubstrate(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return substrate;
    }

    @Override
    public int getDefaultSlot() {
        return 0;
    }

    @Override
    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return 0;
    }

    @Override
    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant) {
        TileEntityGarden garden = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (plant.getPlantTypeClass() == PlantType.GROUND_COVER) {
            return garden.func_70301_a(1) == null ? 1 : -1;
        }
        if (plant.getPlantSizeClass() == PlantSize.FULL) {
            return garden.func_70301_a(0) == null ? 0 : -1;
        }
        if (garden.func_70301_a(0) == null) {
            return 0;
        }
        if (plant.getPlantSizeClass() == PlantSize.SMALL) {
            for (int slot : new int[]{3, 4, 2, 5}) {
                if (garden.func_70301_a(slot) != null) continue;
                return slot;
            }
        }
        for (int slot : new int[]{13, 9, 7, 11, 6, 10, 8, 12}) {
            if (!garden.isSlotValid(slot) || garden.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    @Override
    public boolean applyHoe(World world, int x, int y, int z) {
        TileEntityGarden te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te.isEmpty()) {
            this.convertToFarm(world, x, y, z);
            return true;
        }
        return false;
    }

    public void convertToFarm(World world, int x, int y, int z) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.field_149762_H.func_150498_e(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
        if (!world.field_72995_K) {
            world.func_147449_b(x, y, z, (Block)ModBlocks.gardenFarmland);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("GardenCore:garden_dirt");
    }
}

