/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.api.plant;

import com.jaquadro.minecraft.gardencore.api.PlantRegistry;
import com.jaquadro.minecraft.gardencore.api.plant.IPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class PlantItem {
    private ItemStack plantSourceItem;
    private Block plantBlock;
    private int plantMeta;
    private IPlantInfo plantInfo;

    private PlantItem(ItemStack plantSourceItem, Block plantBlock, int plantMeta) {
        this.plantSourceItem = plantSourceItem;
        this.plantBlock = plantBlock;
        this.plantMeta = plantMeta;
        this.plantInfo = PlantRegistry.instance().getPlantInfoOrDefault(plantBlock, plantMeta);
    }

    public static PlantItem getForItem(IBlockAccess blockAccess, ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return null;
        }
        IPlantable plantable = PlantRegistry.getPlantable(itemStack);
        if (plantable == null) {
            return PlantItem.getForItem(itemStack);
        }
        Block block = plantable.getPlant(blockAccess, 0, -1, 0);
        if (block == null) {
            return PlantItem.getForItem(itemStack);
        }
        int meta = plantable.getPlantMetadata(blockAccess, 0, -1, 0);
        if (meta == 0) {
            meta = itemStack.func_77960_j();
        }
        return new PlantItem(itemStack, block, meta);
    }

    public static PlantItem getForItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == null || !(block instanceof IPlantable)) {
            return null;
        }
        return new PlantItem(itemStack, block, itemStack.func_77960_j());
    }

    public ItemStack getPlantSourceItem() {
        return this.plantSourceItem;
    }

    public Block getPlantBlock() {
        return this.plantBlock;
    }

    public int getPlantMeta() {
        return this.plantMeta;
    }

    public IPlantInfo getPlantInfo() {
        return this.plantInfo;
    }

    public PlantType getPlantTypeClass() {
        return this.plantInfo.getPlantTypeClass(this.plantBlock, this.plantMeta);
    }

    public PlantSize getPlantSizeClass() {
        return this.plantInfo.getPlantSizeClass(this.plantBlock, this.plantMeta);
    }

    public int getPlantMaxHeight() {
        return this.plantInfo.getPlantMaxHeight(this.plantBlock, this.plantMeta);
    }

    public int getPlantHeight() {
        return this.plantInfo.getPlantHeight(this.plantBlock, this.plantMeta);
    }

    public int getPlantSectionMeta(int section) {
        return this.plantInfo.getPlantSectionMeta(this.plantBlock, this.plantMeta, section);
    }
}

