/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.item;

import com.jaquadro.minecraft.gardencontainers.GardenContainers;
import com.jaquadro.minecraft.gardencontainers.config.PatternConfig;
import com.jaquadro.minecraft.gardencontainers.core.ModItems;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPotteryPatternDirty
extends Item {
    public ItemPotteryPatternDirty(String unlocalizedName) {
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(64);
        this.func_77627_a(false);
        this.func_111206_d("GardenContainers:pottery_pattern_dirt");
        this.func_77637_a(ModCreativeTabs.tabGardenCore);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        for (String s : StatCollector.func_74838_a((String)"item.gardencontainers.potteryPatternDirty.description").split("\\\\n")) {
            list.add(s);
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side != 1) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block instanceof BlockCauldron) {
            int waterLevel = BlockCauldron.func_150027_b((int)meta);
            if (waterLevel == 0) {
                return false;
            }
            int index = this.getPatternIndex(world);
            if (index == -1) {
                return false;
            }
            PatternConfig pattern = GardenContainers.config.getPattern(index);
            if (pattern == null) {
                return false;
            }
            ItemStack stamp = new ItemStack((Item)ModItems.potteryPattern, 1, pattern.getId());
            --itemStack.field_77994_a;
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, stamp));
            return true;
        }
        return false;
    }

    private int getPatternIndex(World world) {
        int count = GardenContainers.config.getPatternCount();
        int[] accumWeights = new int[count + 1];
        if (count == 0) {
            return -1;
        }
        for (int i = 1; i <= count; ++i) {
            PatternConfig pattern = GardenContainers.config.getPattern(i);
            accumWeights[i] = accumWeights[i - 1] + pattern.getWeight();
        }
        int maxWeight = accumWeights[accumWeights.length - 1];
        if (maxWeight == 0) {
            return -1;
        }
        int pick = world.field_73012_v.nextInt(maxWeight);
        int index = 1;
        for (int i = 1; i <= count; ++i) {
            if (pick < accumWeights[i - 1]) continue;
            index = i;
        }
        return index;
    }
}

