/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.client.renderer;

import com.jaquadro.minecraft.gardencontainers.block.BlockWindowBox;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityWindowBox;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class WindowBoxRenderer
implements ISimpleBlockRenderingHandler {
    private float[] baseColor = new float[3];
    private float[] activeRimColor = new float[3];
    private float[] activeInWallColor = new float[3];
    private float[] activeBottomColor = new float[3];
    private float[] activeSubstrateColor = new float[3];
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockWindowBox)) {
            return;
        }
        this.renderInventoryBlock((BlockWindowBox)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockWindowBox block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = renderer.func_147787_a((Block)block, 1, metadata);
        float unit = 0.0625f;
        this.boxRenderer.setIcon(icon);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 0.0f * unit, 4.0f * unit, 4.0f * unit, 16.0f * unit, 12.0f * unit, 12.0f * unit, 0, 2);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockWindowBox)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockWindowBox)block, modelId, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockWindowBox block, int modelId, RenderBlocks renderer) {
        ItemStack substrateItem;
        int connect;
        int data = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        IIcon icon = renderer.func_147787_a((Block)block, 1, data);
        RenderHelper.calculateBaseColor(this.baseColor, block.func_149720_d(world, x, y, z));
        RenderHelper.scaleColor(this.activeRimColor, this.baseColor, 0.8f);
        RenderHelper.scaleColor(this.activeInWallColor, this.baseColor, 0.7f);
        RenderHelper.scaleColor(this.activeBottomColor, this.baseColor, 0.6f);
        this.boxRenderer.setIcon(icon);
        this.boxRenderer.setExteriorColor(this.baseColor);
        this.boxRenderer.setInteriorColor(this.activeInWallColor);
        this.boxRenderer.setInteriorColor(this.activeBottomColor, 0);
        this.boxRenderer.setCutColor(this.activeRimColor);
        TileEntityWindowBox te = block.getTileEntity(world, x, y, z);
        boolean validNE = te.isSlotValid(2);
        boolean validNW = te.isSlotValid(1);
        boolean validSE = te.isSlotValid(4);
        boolean validSW = te.isSlotValid(3);
        if (validNW) {
            connect = 0 | (validNE ? 32 : 0) | (validSW ? 8 : 0);
            this.boxRenderer.renderOctant(world, (Block)block, x, (double)y + (te.isUpper() ? 0.5 : 0.0), z, connect, 2);
        }
        if (validNE) {
            connect = 0 | (validNW ? 16 : 0) | (validSE ? 8 : 0);
            this.boxRenderer.renderOctant(world, (Block)block, (double)x + 0.5, (double)y + (te.isUpper() ? 0.5 : 0.0), z, connect, 2);
        }
        if (validSW) {
            connect = 0 | (validSE ? 32 : 0) | (validNW ? 4 : 0);
            this.boxRenderer.renderOctant(world, (Block)block, x, (double)y + (te.isUpper() ? 0.5 : 0.0), (double)z + 0.5, connect, 2);
        }
        if (validSE) {
            connect = 0 | (validSW ? 16 : 0) | (validNE ? 4 : 0);
            this.boxRenderer.renderOctant(world, (Block)block, (double)x + 0.5, (double)y + (te.isUpper() ? 0.5 : 0.0), (double)z + 0.5, connect, 2);
        }
        if ((substrateItem = block.getGardenSubstrate(world, x, y, z, -1)) != null && substrateItem.func_77973_b() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)substrateItem.func_77973_b());
            IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateItem.func_77960_j());
            RenderHelper.calculateBaseColor(this.activeSubstrateColor, substrate.func_149635_D());
            RenderHelper.scaleColor(this.activeSubstrateColor, this.activeSubstrateColor, 0.8f);
            RenderHelper.setTessellatorColor(tessellator, this.activeSubstrateColor);
            double ySubstrate = (te.isUpper() ? 1.0 : 0.5) - 0.0625;
            if (validNW) {
                renderer.func_147782_a(0.0, 0.0, 0.0, 0.5, ySubstrate, 0.5);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, substrateIcon);
            }
            if (validNE) {
                renderer.func_147782_a(0.5, 0.0, 0.0, 1.0, ySubstrate, 0.5);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, substrateIcon);
            }
            if (validSW) {
                renderer.func_147782_a(0.0, 0.0, 0.5, 0.5, ySubstrate, 1.0);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, substrateIcon);
            }
            if (validSE) {
                renderer.func_147782_a(0.5, 0.0, 0.5, 1.0, ySubstrate, 1.0);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, substrateIcon);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.windowBoxRenderID;
    }
}

