/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.block;

import com.jaquadro.minecraft.gardencontainers.block.support.WindowBoxConnectionProfile;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityWindowBox;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot5Profile;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare0Profile;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWindowBox
extends BlockGarden {
    public static final String[] subTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};
    private static ItemStack substrate = new ItemStack(Blocks.field_150346_d, 1);

    public BlockWindowBox(String blockName, Material material) {
        super(blockName, material);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149766_f);
        this.connectionProfile = new WindowBoxConnectionProfile();
        this.slotShareProfile = new SlotShare0Profile();
        PlantType[] commonType = new PlantType[]{PlantType.GROUND};
        PlantSize[] smallSize = new PlantSize[]{PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        PlantSize[] allSize = new PlantSize[]{PlantSize.FULL, PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        this.slotProfile = new LocalSlotProfile(new BasicSlotProfile.Slot[]{new BasicSlotProfile.Slot(0, new PlantType[]{PlantType.GROUND_COVER}, allSize), new BasicSlotProfile.Slot(1, commonType, smallSize), new BasicSlotProfile.Slot(2, commonType, smallSize), new BasicSlotProfile.Slot(3, commonType, smallSize), new BasicSlotProfile.Slot(4, commonType, smallSize)});
    }

    public int func_149645_b() {
        return ClientProxy.windowBoxRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public ItemStack getGardenSubstrate(IBlockAccess world, int x, int y, int z, int slot) {
        return substrate;
    }

    @Override
    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        TileEntityWindowBox tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z);
        if ((double)hitX <= 0.5) {
            if ((double)hitZ <= 0.5 && tileEntity.isSlotValid(1)) {
                return 1;
            }
            if (tileEntity.isSlotValid(3)) {
                return 3;
            }
        } else {
            if ((double)hitZ <= 0.5 && tileEntity.isSlotValid(2)) {
                return 2;
            }
            if (tileEntity.isSlotValid(4)) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant, float hitX, float hitY, float hitZ) {
        return this.getSlot(world, x, y, z, player, hitX, hitY, hitZ);
    }

    @Override
    public TileEntityWindowBox createNewTileEntity(World var1, int var2) {
        return new TileEntityWindowBox();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float yMax;
        TileEntityWindowBox te = this.getTileEntity((IBlockAccess)world, x, y, z);
        boolean validNE = te.isSlotValid(2);
        boolean validNW = te.isSlotValid(1);
        boolean validSE = te.isSlotValid(4);
        boolean validSW = te.isSlotValid(3);
        float yMin = te.isUpper() ? 0.5f : 0.0f;
        float f = yMax = te.isUpper() ? 1.0f : 0.5f;
        if (validNW) {
            this.func_149676_a(0.0f, yMin, 0.0f, 0.5f, yMax, 0.5f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (validNE) {
            this.func_149676_a(0.5f, yMin, 0.0f, 1.0f, yMax, 0.5f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (validSW) {
            this.func_149676_a(0.0f, yMin, 0.5f, 0.5f, yMax, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (validSE) {
            this.func_149676_a(0.5f, yMin, 0.5f, 1.0f, yMax, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        this.setBlockBounds((IBlockAccess)world, x, y, z, validNW, validNE, validSW, validSE);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityWindowBox te = this.getTileEntity(world, x, y, z);
        boolean validNE = te.isSlotValid(2);
        boolean validNW = te.isSlotValid(1);
        boolean validSE = te.isSlotValid(4);
        boolean validSW = te.isSlotValid(3);
        this.setBlockBounds(world, x, y, z, validNW, validNE, validSW, validSE);
    }

    private void setBlockBounds(IBlockAccess world, int x, int y, int z, boolean validNW, boolean validNE, boolean validSW, boolean validSE) {
        TileEntityWindowBox te = this.getTileEntity(world, x, y, z);
        float yMin = te.isUpper() ? 0.5f : 0.0f;
        float yMax = te.isUpper() ? 1.0f : 0.5f;
        float xMin = validNW || validSW ? 0.0f : 0.5f;
        float xMax = validNE || validSE ? 1.0f : 0.5f;
        float zMin = validNW || validNE ? 0.0f : 0.5f;
        float zMax = validSW || validSE ? 1.0f : 0.5f;
        this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityWindowBox te = (TileEntityWindowBox)world.func_147438_o(x, y, z);
        if (te == null || te.getDirection() != 0) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                te.setDirection(3);
                break;
            }
            case 1: {
                te.setDirection(4);
                break;
            }
            case 2: {
                te.setDirection(2);
                break;
            }
            case 3: {
                te.setDirection(5);
            }
        }
        if (world.field_72995_K) {
            te.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 6; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150344_f.func_149691_a(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return Blocks.field_150344_f.func_149673_e(world, x, y, z, side);
    }

    public String[] getSubTypes() {
        return subTypes;
    }

    @Override
    public TileEntityWindowBox getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityWindowBox ? (TileEntityWindowBox)te : null;
    }

    public void func_149651_a(IIconRegister register) {
    }

    private class LocalSlotProfile
    extends Slot5Profile {
        private AxisAlignedBB[] mainClippingBounds;

        public LocalSlotProfile(BasicSlotProfile.Slot[] slots) {
            super(slots);
            this.mainClippingBounds = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875), AxisAlignedBB.func_72330_a((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.125, (double)0.75), AxisAlignedBB.func_72330_a((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125)};
        }

        @Override
        public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            TileEntityWindowBox garden = BlockWindowBox.this.getTileEntity(blockAccess, x, y, z);
            if (garden == null || garden.isUpper()) {
                return -0.0625f;
            }
            return -0.5625f;
        }

        @Override
        public AxisAlignedBB[] getClippingBounds(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            return this.mainClippingBounds;
        }
    }
}

