/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.block;

import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityMediumPot;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.api.block.IChainAttachable;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.block.BlockGardenContainer;
import com.jaquadro.minecraft.gardencore.block.support.BasicConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot2Profile;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare0Profile;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMediumPot
extends BlockGardenContainer
implements IChainAttachable {
    private static final Vec3[] chainAttachPoints = new Vec3[]{Vec3.func_72443_a((double)0.16125, (double)0.75, (double)0.15625), Vec3.func_72443_a((double)0.15625, (double)0.75, (double)0.83875), Vec3.func_72443_a((double)0.84375, (double)0.75, (double)0.16125), Vec3.func_72443_a((double)0.83875, (double)0.75, (double)0.84375)};

    public BlockMediumPot(String blockName) {
        super(blockName, Material.field_151576_e);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.connectionProfile = new BasicConnectionProfile();
        this.slotShareProfile = new SlotShare0Profile();
        PlantType[] commonType = new PlantType[]{PlantType.GROUND};
        PlantSize[] allSize = new PlantSize[]{PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        this.slotProfile = new LocalSlotProfile(new BasicSlotProfile.Slot[]{new BasicSlotProfile.Slot(0, commonType, allSize), new BasicSlotProfile.Slot(1, new PlantType[]{PlantType.GROUND_COVER}, allSize)});
    }

    public abstract String[] getSubTypes();

    @Override
    public int getDefaultSlot() {
        return 0;
    }

    @Override
    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return 0;
    }

    @Override
    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant) {
        if (plant.getPlantTypeClass() == PlantType.GROUND_COVER) {
            return 1;
        }
        return 0;
    }

    public int func_149645_b() {
        return ClientProxy.mediumPotRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            items.add(new ItemStack(item, 1, metadata));
        }
        return items;
    }

    @Override
    public TileEntityMediumPot createNewTileEntity(World world, int meta) {
        return new TileEntityMediumPot();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.75f, 0.875f);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.75f, 0.875f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.75f, 0.875f);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public TileEntityMediumPot getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityMediumPot ? (TileEntityMediumPot)te : null;
    }

    @Override
    public Vec3[] getChainAttachPoints(int side) {
        if (side == 1) {
            return chainAttachPoints;
        }
        return null;
    }

    public void func_149651_a(IIconRegister register) {
    }

    private class LocalSlotProfile
    extends Slot2Profile {
        private AxisAlignedBB[] mainClippingBounds;

        public LocalSlotProfile(BasicSlotProfile.Slot[] slots) {
            super(slots);
            this.mainClippingBounds = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.0625, (double)0.8125), AxisAlignedBB.func_72330_a((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
        }

        @Override
        public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            return -0.3125f;
        }

        @Override
        public AxisAlignedBB[] getClippingBounds(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            return this.mainClippingBounds;
        }
    }
}

