/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.block;

import com.InfinityRaider.AgriCraft.api.v1.ISoilContainer;
import com.jaquadro.minecraft.gardencontainers.GardenContainers;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityLargePot;
import com.jaquadro.minecraft.gardencontainers.config.PatternConfig;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.api.block.IChainAttachable;
import com.jaquadro.minecraft.gardencore.api.block.IGardenBlock;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.block.BlockGardenContainer;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.ContainerConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot14ProfileBounded;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare8Profile;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(modid="AgriCraft", iface="com.InfinityRaider.AgriCraft.api.v1.ISoilContainer")
public abstract class BlockLargePot
extends BlockGardenContainer
implements IChainAttachable,
ISoilContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayArray;
    private static final Vec3[] chainAttachPoints = new Vec3[]{Vec3.func_72443_a((double)0.03625, (double)1.0, (double)0.03125), Vec3.func_72443_a((double)0.03125, (double)1.0, (double)0.96375), Vec3.func_72443_a((double)0.96875, (double)1.0, (double)0.03625), Vec3.func_72443_a((double)0.96375, (double)1.0, (double)0.96875)};

    public BlockLargePot(String blockName) {
        super(blockName, Material.field_151571_B);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.connectionProfile = new ContainerConnectionProfile();
        this.slotShareProfile = new SlotShare8Profile(6, 7, 8, 9, 10, 11, 12, 13);
        PlantType[] commonType = new PlantType[]{PlantType.GROUND, PlantType.AQUATIC_COVER, PlantType.AQUATIC_SURFACE};
        PlantSize[] commonSize = new PlantSize[]{PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        PlantSize[] allSize = new PlantSize[]{PlantSize.FULL, PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        this.slotProfile = new LocalSlotProfile(this, new BasicSlotProfile.Slot[]{new BasicSlotProfile.Slot(0, commonType, allSize), new BasicSlotProfile.Slot(1, new PlantType[]{PlantType.GROUND_COVER}, allSize), new BasicSlotProfile.Slot(2, commonType, commonSize), new BasicSlotProfile.Slot(3, commonType, commonSize), new BasicSlotProfile.Slot(4, commonType, commonSize), new BasicSlotProfile.Slot(5, commonType, commonSize), new BasicSlotProfile.Slot(6, commonType, commonSize), new BasicSlotProfile.Slot(7, commonType, commonSize), new BasicSlotProfile.Slot(8, commonType, commonSize), new BasicSlotProfile.Slot(9, commonType, commonSize), new BasicSlotProfile.Slot(10, commonType, commonSize), new BasicSlotProfile.Slot(11, commonType, commonSize), new BasicSlotProfile.Slot(12, commonType, commonSize), new BasicSlotProfile.Slot(13, commonType, commonSize)});
    }

    public abstract String[] getSubTypes();

    @Override
    public int getDefaultSlot() {
        return 0;
    }

    @Override
    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return 0;
    }

    @Override
    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant) {
        TileEntityLargePot garden = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (plant.getPlantTypeClass() == PlantType.GROUND_COVER) {
            return garden.func_70301_a(1) == null ? 1 : -1;
        }
        if (plant.getPlantSizeClass() == PlantSize.FULL) {
            return garden.func_70301_a(0) == null ? 0 : -1;
        }
        if (garden.func_70301_a(0) == null) {
            return 0;
        }
        if (plant.getPlantSizeClass() == PlantSize.SMALL) {
            for (int slot : new int[]{3, 4, 2, 5}) {
                if (garden.func_70301_a(slot) != null) continue;
                return slot;
            }
        }
        for (int slot : new int[]{13, 9, 7, 11, 6, 10, 8, 12}) {
            if (!garden.isSlotValid(slot) || garden.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float dim = 0.0625f;
        TileEntityLargePot te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null || te.getSubstrate() == null || !this.isSubstrateSolid(te.getSubstrate().func_77973_b())) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, dim, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f - dim, 1.0f);
        }
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        if (!te.isAttachedNeighbor(x - 1, y, z)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, dim, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!te.isAttachedNeighbor(x, y, z - 1)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, dim);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!te.isAttachedNeighbor(x + 1, y, z)) {
            this.func_149676_a(1.0f - dim, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!te.isAttachedNeighbor(x, y, z + 1)) {
            this.func_149676_a(0.0f, 0.0f, 1.0f - dim, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.largePotRenderID;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityLargePot te;
        int nx = x++;
        int nz = z++;
        switch (side) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                --x;
            }
        }
        if (side >= 2 && side < 6 && (te = this.getTileEntity(blockAccess, x, y, z)) != null) {
            return !te.isAttachedNeighbor(nx, y, nz);
        }
        return side != 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityLargePot te = this.getTileEntity((IBlockAccess)world, x, y, z);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            int packedMeta = metadata | (te != null ? te.getCarving() << 8 : 0);
            if (item == null) continue;
            items.add(new ItemStack(item, 1, packedMeta));
        }
        return items;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    private boolean isSubstrateSolid(Item item) {
        Block block = Block.func_149634_a((Item)item);
        return block != Blocks.field_150355_j;
    }

    @Override
    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        TileEntityLargePot gardenTile = this.getTileEntity(world, x, y, z);
        EnumPlantType plantType = plantable.getPlantType(world, x, y, z);
        if (plantType == EnumPlantType.Crop) {
            return this.substrateSupportsCrops(gardenTile.getSubstrate());
        }
        return false;
    }

    protected boolean substrateSupportsCrops(ItemStack substrate) {
        if (substrate == null || substrate.func_77973_b() == null) {
            return false;
        }
        if (Block.func_149634_a((Item)substrate.func_77973_b()) == ModBlocks.gardenFarmland) {
            return true;
        }
        return Block.func_149634_a((Item)substrate.func_77973_b()) == Blocks.field_150458_ak;
    }

    @Override
    protected boolean applySubstrateToGarden(World world, int x, int y, int z, EntityPlayer player, int slot, ItemStack itemStack) {
        if (this.getGardenSubstrate((IBlockAccess)world, x, y, z, slot) != null) {
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_151131_as) {
            TileEntityLargePot garden = this.getTileEntity((IBlockAccess)world, x, y, z);
            garden.setSubstrate(new ItemStack(Blocks.field_150355_j));
            garden.func_70296_d();
            if (player != null && !player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
            }
            world.func_147471_g(x, y, z);
            return true;
        }
        return super.applySubstrateToGarden(world, x, y, z, player, slot, itemStack);
    }

    @Override
    protected boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack, float hitX, float hitY, float hitZ, boolean hitValid) {
        ItemStack item;
        ItemStack itemStack2 = item = itemStack == null ? player.field_71071_by.func_70448_g() : itemStack;
        if (item == null) {
            return false;
        }
        TileEntityLargePot garden = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (garden.getSubstrate() != null) {
            if (item.func_77973_b() == Items.field_151133_ar) {
                if (Block.func_149634_a((Item)garden.getSubstrate().func_77973_b()) == Blocks.field_150355_j) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151131_as));
                    garden.setSubstrate(null);
                    garden.func_70296_d();
                    world.func_147471_g(x, y, z);
                }
                return true;
            }
            if (item.func_77973_b() == Items.field_151131_as) {
                this.applyWaterToSubstrate(world, x, y, z, garden, player);
                return true;
            }
            if (item.func_77973_b() instanceof ItemHoe) {
                this.applyHoeToSubstrate(world, x, y, z, garden, player);
                return true;
            }
        }
        return super.applyItemToGarden(world, x, y, z, player, itemStack, hitX, hitY, hitZ, hitValid);
    }

    protected void applyWaterToSubstrate(World world, int x, int y, int z, TileEntityGarden tile, EntityPlayer player) {
        if (Block.func_149634_a((Item)tile.getSubstrate().func_77973_b()) == Blocks.field_150346_d) {
            tile.setSubstrate(new ItemStack(Blocks.field_150458_ak, 1, 7), new ItemStack(Blocks.field_150346_d, 1, tile.getSubstrate().func_77960_j()));
            tile.func_70296_d();
            world.func_147471_g(x, y, z);
        }
    }

    protected boolean applyHoeToSubstrate(World world, int x, int y, int z, TileEntityGarden tile, EntityPlayer player) {
        Block substrate = Block.func_149634_a((Item)tile.getSubstrate().func_77973_b());
        if (substrate == Blocks.field_150346_d || substrate == Blocks.field_150349_c) {
            tile.setSubstrate(new ItemStack(Blocks.field_150458_ak, 1, 7), new ItemStack(Blocks.field_150346_d, 1, tile.getSubstrate().func_77960_j()));
        } else if (substrate == ModBlocks.gardenSoil) {
            tile.setSubstrate(new ItemStack((Block)ModBlocks.gardenFarmland), new ItemStack((Block)ModBlocks.gardenSoil));
        } else {
            return false;
        }
        tile.func_70296_d();
        world.func_147471_g(x, y, z);
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
        return true;
    }

    @Override
    public boolean applyHoe(World world, int x, int y, int z) {
        TileEntityLargePot te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te.isEmpty()) {
            return this.applyHoeToSubstrate(world, x, y, z, te, null);
        }
        return false;
    }

    @Override
    public TileEntityLargePot getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityLargePot ? (TileEntityLargePot)te : null;
    }

    @Override
    public TileEntityLargePot createNewTileEntity(World world, int data) {
        return new TileEntityLargePot();
    }

    @Override
    public Vec3[] getChainAttachPoints(int side) {
        if (side == 1) {
            return chainAttachPoints;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(int data) {
        if (this.iconOverlayArray[data] != null) {
            return this.iconOverlayArray[data];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconOverlayArray = new IIcon[256];
        for (int i = 1; i < this.iconOverlayArray.length; ++i) {
            PatternConfig pattern = GardenContainers.config.getPattern(i);
            if (pattern == null || pattern.getOverlay() == null) continue;
            this.iconOverlayArray[i] = iconRegister.func_94245_a("GardenContainers:" + pattern.getOverlay());
        }
    }

    public Block getSoil(World world, int x, int y, int z) {
        ItemStack substrate = this.getGardenSubstrate((IBlockAccess)world, x, y, z, this.getDefaultSlot());
        if (substrate == null || substrate.func_77973_b() == null || !(substrate.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)substrate.func_77973_b()).field_150939_a;
    }

    public int getSoilMeta(World world, int x, int y, int z) {
        ItemStack substrate = this.getGardenSubstrate((IBlockAccess)world, x, y, z, this.getDefaultSlot());
        if (substrate == null || substrate.func_77973_b() == null || !(substrate.func_77973_b() instanceof ItemBlock)) {
            return -1;
        }
        return substrate.func_77960_j();
    }

    private class LocalSlotProfile
    extends Slot14ProfileBounded {
        public LocalSlotProfile(IGardenBlock garden, BasicSlotProfile.Slot[] slots) {
            super(garden, slots);
        }

        @Override
        public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            return -0.0625f;
        }

        @Override
        public Object openPlantGUI(InventoryPlayer playerInventory, TileEntity gardenTile, boolean client) {
            if (gardenTile instanceof TileEntityGarden && ((TileEntityGarden)gardenTile).getSubstrate() == null) {
                return null;
            }
            return super.openPlantGUI(playerInventory, gardenTile, client);
        }
    }
}

