/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardenstuff.GardenStuff;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import com.jaquadro.minecraft.gardenstuff.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardenstuff.core.handlers.GuiHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBloomeryFurnace
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockBloomeryFurnace(String registryName, String unlocalizedName) {
        super(Material.field_151576_e);
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ModCreativeTabs.tabGardenStuff);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.bloomeryFurnace);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState bsNorth = world.func_180495_p(pos.func_177978_c());
            IBlockState bsSouth = world.func_180495_p(pos.func_177968_d());
            IBlockState bsWest = world.func_180495_p(pos.func_177976_e());
            IBlockState bsEast = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && bsNorth.func_185913_b() && !bsSouth.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && bsSouth.func_185913_b() && !bsNorth.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && bsWest.func_185913_b() && !bsEast.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && bsEast.func_185913_b() && !bsWest.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloomeryFurnace) {
            player.openGui((Object)GardenStuff.instance, GuiHandler.BLOOMERY_FURNACE_ID, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(active)), 3);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileBloomeryFurnace();
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 14 : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getLightValue(state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tile;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof TileBloomeryFurnace) {
            ((TileBloomeryFurnace)tile).setInventoryName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloomeryFurnace) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileBloomeryFurnace)tile));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Nullable
    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.bloomeryFurnace);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        boolean lit = (meta & 8) > 0;
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        int litBit = (Boolean)state.func_177229_b((IProperty)LIT) != false ? 8 : 0;
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | litBit;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        float fx = (float)pos.func_177958_n() + 0.5f;
        float fy = (float)pos.func_177956_o() + rand.nextFloat() * 6.0f / 16.0f;
        float fz = (float)pos.func_177952_p() + 0.5f;
        float depth = 0.52f;
        float adjust = rand.nextFloat() * 0.6f - 0.3f;
        if (rand.nextDouble() < 0.1) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(fx - depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(fx - depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(fx + depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(fx + depth), (double)fy, (double)(fz + adjust), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(fx + adjust), (double)fy, (double)(fz - depth), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(fx + adjust), (double)fy, (double)(fz - depth), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(fx + adjust), (double)fy, (double)(fz + depth), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(fx + adjust), (double)fy, (double)(fz + depth), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fx, (double)(fy + 0.5f), (double)fz, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

