/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenTransmitter;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOxygenPipe
extends TileEntityOxygenTransmitter
implements IColorable {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public byte pipeColor = (byte)15;
    private byte lastPipeColor = (byte)-1;

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        TileEntity adjacentTile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, direction);
        if (type == NetworkType.OXYGEN) {
            if (adjacentTile instanceof IColorable) {
                return this.getColor() == ((IColorable)adjacentTile).getColor();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUpdate() {
        return this.field_145850_b == null || !this.field_145850_b.field_72995_K;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.ticks % 60 == 0 && this.lastPipeColor != this.getColor() && !this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketDynamic(this), this.field_145850_b.field_73011_w.field_76574_g);
            this.lastPipeColor = this.getColor();
        }
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 5;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void setColor(byte col) {
        this.pipeColor = col;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                this.getNetwork().split(this);
                this.resetNetwork();
            }
        }
    }

    @Override
    public byte getColor() {
        return this.pipeColor;
    }

    @Override
    public void onAdjacentColorChanged(ForgeDirection direction) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            this.refresh();
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.setColor(par1NBTTagCompound.func_74771_c("pipeColor"));
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("pipeColor", this.getColor());
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        byte colorBefore = this.pipeColor;
        super.decodePacketdata(buffer);
        if (this.pipeColor != colorBefore && this.field_145850_b instanceof WorldClient) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

