/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.fx.EntityFXLanderFlame;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityLander
extends EntityLanderBase
implements IIgnoreShift,
ICameraZoomEntity {
    private double lastMotionY;

    public EntityLander(World world) {
        super(world, 0.0f);
        this.func_70105_a(3.0f, 4.25f);
    }

    public EntityLander(EntityPlayerMP player) {
        super(player, 0.0f);
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O - 2.0;
    }

    @Override
    public float getRotateOffset() {
        return 0.0f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.lastMotionY = this.field_70181_x;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lastMotionY = this.field_70181_x;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.lander.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                return false;
            }
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            return true;
        }
        if (this.field_70153_n == null && var1 instanceof EntityPlayerMP) {
            GCCoreUtil.openParachestInv((EntityPlayerMP)var1, this);
            return true;
        }
        if (var1 instanceof EntityPlayerMP) {
            if (!this.field_70122_E) {
                return false;
            }
            var1.func_70078_a(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean pressKey(int key) {
        if (this.field_70122_E) {
            return false;
        }
        float turnFactor = 2.0f;
        float angle = 45.0f;
        switch (key) {
            case 0: {
                this.field_70125_A = Math.min(Math.max(this.field_70125_A - 0.5f * turnFactor, -angle), angle);
                return true;
            }
            case 1: {
                this.field_70125_A = Math.min(Math.max(this.field_70125_A + 0.5f * turnFactor, -angle), angle);
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * turnFactor;
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * turnFactor;
                return true;
            }
            case 4: {
                this.field_70181_x = Math.min(this.field_70181_x + (double)0.03f, this.field_70163_u < 90.0 ? -0.15 : -1.0);
                return true;
            }
            case 5: {
                this.field_70181_x = Math.min(this.field_70181_x - (double)0.022f, -1.0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return this.ticks > 40L && this.field_70125_A != 1.0E-7f;
    }

    @Override
    public Map<Vector3, Vector3> getParticleMap() {
        double x1 = 4.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 4.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = -4.0 * Math.abs(Math.cos((double)this.field_70125_A * Math.PI / 180.0));
        new Vector3(this);
        HashMap<Vector3, Vector3> particleMap = new HashMap<Vector3, Vector3>();
        particleMap.put(new Vector3(this.field_70165_t, this.field_70163_u + 1.0 + this.field_70181_x / 2.0, this.field_70161_v), new Vector3(x1, y1 + this.field_70181_x / 2.0, z1));
        return particleMap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityFX getParticle(Random rand, double x, double y, double z, double motX, double motY, double motZ) {
        return new EntityFXLanderFlame(this.field_70170_p, x, y, z, motX, motY, motZ, this.field_70153_n instanceof EntityLivingBase ? (EntityLivingBase)this.field_70153_n : null);
    }

    @Override
    public void tickInAir() {
        super.tickInAir();
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                this.field_70181_x -= 0.008;
            }
            double motY = -1.0 * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
            double motX = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * motY;
            double motZ = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * motY;
            this.field_70159_w = motX / 2.0;
            this.field_70179_y = motZ / 2.0;
        }
    }

    @Override
    public void tickOnGround() {
        this.field_70125_A = 1.0E-7f;
    }

    @Override
    public void onGroundHit() {
        if (!this.field_70170_p.field_72995_K && Math.abs(this.lastMotionY) > 2.0) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerMP) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, true);
            this.func_70106_y();
        }
    }

    @Override
    public Vector3 getMotionVec() {
        if (this.field_70122_E) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        if (this.ticks >= 40L && this.ticks < 45L) {
            this.field_70181_x = this.getInitialMotionY();
        }
        return new Vector3(this.field_70159_w, this.ticks < 40L ? 0.0 : this.field_70181_x, this.field_70179_y);
    }

    @Override
    public float getCameraZoom() {
        return 15.0f;
    }

    @Override
    public boolean defaultThirdPerson() {
        return true;
    }

    @Override
    public boolean shouldIgnoreShiftExit() {
        return !this.field_70122_E;
    }

    @Override
    public double getInitialMotionY() {
        return -2.5;
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }
}

