/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDish
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc,
IPartialSealableBlock {
    private IIcon[] icons = new IIcon[6];

    public BlockDish(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.icons[0] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[1] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[2] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[3] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[4] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[5] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.field_149761_L = this.icons[0];
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public boolean func_149707_d(World world, int x1, int y1, int z1, int side) {
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Block block = world.func_147439_a(x1 + (y == 2 ? x : 0), y1 + y, z1 + (y == 2 ? z : 0));
                    if (block.func_149688_o() == Material.field_151579_a || block.isReplaceable((IBlockAccess)world, x1 + x, y1 + y, z1 + z)) continue;
                    return false;
                }
            }
        }
        return new BlockVec3(x1, y1, z1).newVecSide(side ^ 1).getBlock((IBlockAccess)world) != GCBlocks.fakeBlock;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityDish) {
            ((TileEntityDish)tile).onCreate(new BlockVec3(x, y, z));
        }
    }

    @Override
    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var9 = var1.func_147438_o(var2, var3, var4);
        if (var9 instanceof TileEntityDish) {
            ((TileEntityDish)var9).onDestroy(var9);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return true;
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityDish();
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate("tile.radioTelescope.description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }
}

