/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class Rank
extends FinalIDObject
implements Comparable<Rank> {
    public static final String NODE_PARENT = "parent";
    public static final String NODE_DEFAULT_PLAYER = "default_player_rank";
    public static final String NODE_DEFAULT_OP = "default_op_rank";
    public static final String NODE_POWER = "power";
    public static final String NODE_COMMAND = "command";
    public final Ranks ranks;
    private int power;
    protected ITextComponent displayName = new TextComponentString(this.getId());
    protected Set<Rank> parents;
    public final Map<String, Entry> permissions;
    public String comment;

    public Rank(Ranks r, String id) {
        super(id);
        this.displayName.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        this.ranks = r;
        this.permissions = new LinkedHashMap<String, Entry>();
        this.comment = "";
        this.power = -1;
    }

    public int getPower() {
        if (this.power == -1) {
            String s = this.getLocalPermission(NODE_POWER);
            this.power = s.isEmpty() ? 0 : MathHelper.func_76125_a((int)Integer.parseInt(s), (int)0, (int)0x7FFFFFFE);
        }
        return this.power;
    }

    public boolean isPlayer() {
        return false;
    }

    public void clearCache() {
        this.parents = null;
        this.power = -1;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public Set<Rank> getParents() {
        if (this.parents == null) {
            ArrayList<Rank> list = new ArrayList<Rank>();
            for (String s : this.getLocalPermission(NODE_PARENT).split(",")) {
                Rank r = this.ranks.getRank(s.trim());
                if (r == null || r.isPlayer()) continue;
                list.add(r);
            }
            list.sort(null);
            this.parents = new LinkedHashSet<Rank>(list);
        }
        return this.parents;
    }

    public Set<Rank> getActualParents() {
        return this.getParents();
    }

    public boolean addParent(@Nullable Rank rank) {
        if (rank == null || rank.isPlayer()) {
            return false;
        }
        this.parents = this.getParents();
        if (this.parents.add(rank)) {
            this.setPermission(NODE_PARENT, StringJoiner.with((String)", ").join(this.parents));
            this.parents = null;
            return true;
        }
        return false;
    }

    public boolean removeParent(Rank rank) {
        this.parents = this.getParents();
        if (this.parents.remove(rank)) {
            this.setPermission(NODE_PARENT, StringJoiner.with((String)", ").join(this.parents));
            this.parents = null;
            return true;
        }
        return false;
    }

    public boolean clearParents() {
        this.power = -1;
        this.parents = null;
        return this.setPermission(NODE_PARENT, "") != null;
    }

    @Nullable
    public Entry setPermission(String node, @Nullable Object value) {
        String v;
        String string = v = value == null ? "" : value.toString();
        if (v.isEmpty()) {
            return this.permissions.remove(node);
        }
        Entry entry = this.permissions.get(node);
        if (entry != null) {
            if (!entry.value.equals(v)) {
                entry.value = v;
                return entry;
            }
            return null;
        }
        entry = new Entry(node);
        entry.value = v;
        this.permissions.put(node, entry);
        return entry;
    }

    public String getLocalPermission(String node) {
        Entry entry = this.permissions.get(node);
        return entry == null ? "" : entry.value;
    }

    public String getPermission(String node) {
        return this.getPermission(node, node, false);
    }

    public String getPermission(String originalNode, String node, boolean recursive) {
        String s = this.getLocalPermission(node);
        if (!s.isEmpty()) {
            return s;
        }
        for (Rank parent : this.getActualParents()) {
            s = parent.getPermission(node);
            if (s.isEmpty()) continue;
            return s;
        }
        if (recursive) {
            int i = node.lastIndexOf(46);
            if (i != -1) {
                return this.getPermission(originalNode, node.substring(0, i), true);
            }
            if (!node.equals("*")) {
                return this.getPermission(originalNode, "*", true);
            }
        }
        return "";
    }

    public ConfigValue getPermissionValue(String node) {
        return this.getPermissionValue(node, node, false);
    }

    public ConfigValue getPermissionValue(String originalNode, String node, boolean recursive) {
        String s = this.getPermission(originalNode, node, recursive);
        if (s.isEmpty()) {
            return ConfigNull.INSTANCE;
        }
        if (s.equals("true")) {
            return new ConfigBoolean(true);
        }
        if (s.equals("false")) {
            return new ConfigBoolean(false);
        }
        RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(originalNode);
        if (info != null) {
            ConfigValue value = info.defaultValue.copy();
            value.setValueFromString(null, s, false);
            return value;
        }
        return new ConfigString(s);
    }

    public boolean add() {
        return this.ranks.ranks.put(this.getId(), this) != this;
    }

    public boolean remove() {
        if (this.ranks.ranks.remove(this.getId()) != null) {
            for (Rank rank : this.ranks.ranks.values()) {
                rank.removeParent(this);
            }
            for (Rank rank : this.ranks.playerRanks.values()) {
                rank.removeParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Rank o) {
        return Integer.compare(o.getPower(), this.getPower());
    }

    public boolean isDefaultPlayerRank() {
        return this.getLocalPermission(NODE_DEFAULT_PLAYER).equals("true");
    }

    public boolean isDefaultOPRank() {
        return this.getLocalPermission(NODE_DEFAULT_OP).equals("true");
    }

    public static class Entry
    implements Comparable<Entry> {
        public final String node;
        public String value = "";
        public String comment = "";

        public Entry(String n) {
            this.node = n;
        }

        @Override
        public int compareTo(Entry o) {
            return this.node.compareTo(o.node);
        }

        public String toString() {
            return this.node + ":" + this.value;
        }
    }
}

