/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigDouble;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import com.feed_the_beast.ftbutilities.ranks.CommandOverride;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.RankNone;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

public class Ranks {
    public static Ranks INSTANCE;
    public final Universe universe;
    public final Rank none;
    public final Map<String, Rank> ranks = new LinkedHashMap<String, Rank>();
    private Collection<String> rankNames = null;
    private Collection<String> permissionNodes = null;
    public final Map<UUID, Rank> playerMap = new HashMap<UUID, Rank>();
    private Rank defaultPlayerRank;
    private Rank defaultOPRank;
    public final Map<Node, CommandOverride> commands = new LinkedHashMap<Node, CommandOverride>();

    public static boolean isActive() {
        return FTBUtilitiesConfig.ranks.enabled && INSTANCE != null && PermissionAPI.getPermissionHandler() == FTBUtilitiesPermissionHandler.INSTANCE;
    }

    public static Event.Result getPermissionResult(@Nullable MinecraftServer server, GameProfile profile, Node node, @Nullable IContext context, boolean matching) {
        if (!Ranks.isActive()) {
            return Event.Result.DEFAULT;
        }
        if (context != null && context.getWorld() != null && context.getWorld().field_72995_K) {
            if (FTBUtilitiesConfig.ranks.crash_client_side_permissions) {
                throw new RuntimeException("Do not check permissions on client side! Node: " + node);
            }
            return Event.Result.DEFAULT;
        }
        Rank rank = INSTANCE.getRank(server, profile, context);
        if (rank.isNone()) {
            return Event.Result.DEFAULT;
        }
        Event.Result result = rank.cachedPermissions.get(node);
        if (result == null) {
            result = rank.getPermissionRaw(node, matching);
            rank.cachedPermissions.put(node, result);
        }
        return result;
    }

    public static Event.Result getPermissionResult(EntityPlayerMP player, Node node, boolean matching) {
        if (!Ranks.isActive()) {
            return Event.Result.DEFAULT;
        }
        return Ranks.getPermissionResult(player.field_71133_b, player.func_146103_bH(), node, (IContext)new PlayerContext((EntityPlayer)player), matching);
    }

    public static boolean isValidName(@Nullable String id) {
        if (id == null || id.isEmpty() || id.equals("none")) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public Ranks(Universe u) {
        this.universe = u;
        this.none.parent = this.none = new RankNone(this, "none");
    }

    public Rank getRank(String id) {
        Rank rank = Ranks.isValidName(id) ? this.ranks.get(id) : null;
        return rank == null ? this.none : rank;
    }

    public Rank getDefaultPlayerRank() {
        if (this.defaultPlayerRank == null) {
            this.defaultPlayerRank = this.none;
            for (Rank rank : this.ranks.values()) {
                if (!rank.tags.contains("default_player_rank")) continue;
                this.defaultPlayerRank = rank;
            }
        }
        return this.defaultPlayerRank;
    }

    public Rank getDefaultOPRank() {
        if (this.defaultOPRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.tags.contains("default_op_rank")) continue;
                this.defaultOPRank = rank;
            }
            if (this.defaultOPRank == null) {
                this.defaultOPRank = this.getDefaultPlayerRank();
            }
        }
        return this.defaultOPRank;
    }

    @Nullable
    public Rank getSetRank(GameProfile profile) {
        return Ranks.isActive() && profile.getId() != null ? this.playerMap.get(profile.getId()) : null;
    }

    public Rank getRank(@Nullable MinecraftServer server, GameProfile profile, @Nullable IContext context) {
        Rank r = this.getSetRank(profile);
        return r == null ? (ServerUtils.isOP((MinecraftServer)server, (GameProfile)profile) ? this.getDefaultOPRank() : this.getDefaultPlayerRank()) : r;
    }

    public void addRank(Rank rank) {
        if (!rank.isNone() && this.ranks.put(rank.getID(), rank) != rank) {
            this.universe.clearCache();
            this.saveRanks();
        }
    }

    public boolean removeRank(Rank rank) {
        if (!rank.isNone() && this.ranks.remove(rank.getID()) != null) {
            if (this.playerMap.values().removeIf(r -> r == rank)) {
                this.savePlayerRanks();
            }
            for (Rank rank1 : this.ranks.values()) {
                if (rank1.parent != rank) continue;
                rank1.parent = this.none;
            }
            this.universe.clearCache();
            this.saveRanks();
            return true;
        }
        return false;
    }

    public boolean setRank(UUID id, Rank rank) {
        boolean result;
        if (rank.isNone()) {
            result = this.playerMap.remove(id) != null;
        } else {
            boolean bl = result = this.playerMap.put(id, rank) != rank;
        }
        if (result) {
            this.universe.clearCache();
            this.savePlayerRanks();
            return true;
        }
        return false;
    }

    public Collection<String> getPermissionNodes() {
        if (this.permissionNodes == null) {
            this.permissionNodes = new LinkedHashSet<String>();
            for (String s : FTBUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
                String desc = DefaultPermissionHandler.INSTANCE.getNodeDescription(s);
                Node node = Node.get((String)s);
                boolean printNode = true;
                for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                    if (!entry.getNode().matches(node)) continue;
                    if (entry.level == null || level != entry.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                this.permissionNodes.add(s);
            }
            for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                this.permissionNodes.add(entry.node.toString());
            }
            for (Node node : this.commands.keySet()) {
                this.permissionNodes.add(node.toString());
            }
            for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                this.permissionNodes.add(info.node.toString());
            }
            this.permissionNodes = Arrays.asList(this.permissionNodes.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.permissionNodes;
    }

    public Collection<String> getRankNames(boolean includeNone) {
        if (!includeNone) {
            return this.ranks.keySet();
        }
        if (this.rankNames == null) {
            this.rankNames = new ArrayList<String>(this.ranks.keySet());
            this.rankNames.add("none");
            this.rankNames = Arrays.asList(this.rankNames.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.rankNames;
    }

    public boolean reload() {
        this.ranks.clear();
        this.playerMap.clear();
        this.clearCache();
        if (!Ranks.isActive()) {
            return true;
        }
        boolean result = true;
        boolean loadedOldFile = false;
        File ranksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/ranks.json");
        JsonElement ranksJson = DataReader.get((File)ranksFile).safeJson();
        HashMap<String, String> rankParents = new HashMap<String, String>();
        if (ranksJson.isJsonObject()) {
            JsonObject json = ranksJson.getAsJsonObject();
            if (json.has("ranks")) {
                for (Map.Entry entry : json.get("ranks").getAsJsonObject().entrySet()) {
                    if (Ranks.isValidName((String)entry.getKey())) continue;
                    this.ranks.put((String)entry.getKey(), new Rank(this, (String)entry.getKey()));
                }
                for (Map.Entry rankEntry : json.get("ranks").getAsJsonObject().entrySet()) {
                    if (!Ranks.isValidName((String)rankEntry.getKey())) continue;
                    Rank rank = new Rank(this, (String)rankEntry.getKey());
                    this.ranks.put(rank.getID(), rank);
                    JsonElement json0 = (JsonElement)rankEntry.getValue();
                    if (!json0.isJsonObject()) continue;
                    JsonObject o = json0.getAsJsonObject();
                    if (o.has("parent")) {
                        rankParents.put(rank.getID(), o.get("parent").getAsString());
                    }
                    if (o.has("permissions")) {
                        JsonElement e1 = o.get("permissions");
                        if (e1.isJsonArray()) {
                            JsonArray a = e1.getAsJsonArray();
                            for (int i = 0; i < a.size(); ++i) {
                                String id = a.get(i).getAsString();
                                char firstChar = id.charAt(0);
                                String key = firstChar == '-' || firstChar == '+' || firstChar == '~' ? id.substring(1) : id;
                                key = key.replace("command.ftb.reload", "command.ftblib.reload");
                                key = key.replace("command.ftb.team", "command.ftblib.team");
                                key = key.replace("command.ftb.my_settings", "command.ftblib.my_settings");
                                key = key.replace("command.ftb", "command.ftbutilities");
                                rank.setPermission(Node.get((String)key), (JsonElement)(firstChar == '-' ? JsonUtils.JSON_FALSE : JsonUtils.JSON_TRUE));
                            }
                        } else {
                            JsonObject o1 = e1.getAsJsonObject();
                            for (Map.Entry entry : o1.entrySet()) {
                                String key = (String)entry.getKey();
                                key = key.replace("command.ftb.reload", "command.ftblib.reload");
                                key = key.replace("command.ftb.team", "command.ftblib.team");
                                key = key.replace("command.ftb.my_settings", "command.ftblib.my_settings");
                                key = key.replace("command.ftb", "command.ftbutilities");
                                rank.setPermission(Node.get((String)key), (JsonElement)entry.getValue());
                            }
                        }
                    }
                    if (!o.has("config")) continue;
                    for (Map.Entry entry : o.get("config").getAsJsonObject().entrySet()) {
                        rank.setPermission(Node.get((String)((String)entry.getKey())), (JsonElement)entry.getValue());
                    }
                }
                if (json.has("default_ranks")) {
                    Rank rank;
                    JsonObject dr = json.get("default_ranks").getAsJsonObject();
                    if (dr.has("player") && !(rank = this.getRank(dr.get("player").getAsString())).isNone()) {
                        rank.tags.add("default_player_rank");
                    }
                    if (dr.has("op") && !(rank = this.getRank(dr.get("op").getAsString())).isNone()) {
                        rank.tags.add("default_op_rank");
                    }
                }
            }
            loadedOldFile = true;
            FileUtils.deleteSafe((File)ranksFile);
        }
        File file = ranksFile = FTBUtilitiesConfig.ranks.load_from_config_folder ? new File(Loader.instance().getConfigDir(), "ftbutilities_ranks.txt") : new File(this.universe.server.func_71238_n(), "local/ftbutilities/ranks.txt");
        if (!loadedOldFile && !ranksFile.exists()) {
            Rank pRank = new Rank(this, "player");
            this.ranks.put(pRank.getID(), pRank);
            pRank.tags.add("default_player_rank");
            pRank.setPermission(Node.get((String)"example.permission"), (JsonElement)JsonUtils.JSON_TRUE);
            pRank.setPermission(Node.get((String)"example.other_permission"), (JsonElement)JsonUtils.JSON_FALSE);
            Rank oRank = new Rank(this, "admin");
            this.ranks.put(oRank.getID(), oRank);
            oRank.tags.add("default_op_rank");
            oRank.parent = pRank;
            oRank.setPermission(Node.get((String)"example.other_permission"), (JsonElement)JsonUtils.JSON_TRUE);
        }
        Rank currentRank = null;
        for (String line : DataReader.get((File)ranksFile).safeStringList()) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String[] iss = line.substring(1, line.length() - 1).split(" is ", 2);
                String[] extendss = iss[0].split(" extends ", 2);
                currentRank = new Rank(this, StringUtils.removeAllWhitespace((String)extendss[0]));
                if (Ranks.isValidName(currentRank.getID())) {
                    this.ranks.put(currentRank.getID(), currentRank);
                }
                String parent = "";
                if (iss.length == 2) {
                    for (String tag : iss[1].split(",")) {
                        String s = StringUtils.removeAllWhitespace((String)tag);
                        if (s.isEmpty()) continue;
                        currentRank.tags.add(s);
                    }
                }
                if (extendss.length == 2) {
                    parent = StringUtils.removeAllWhitespace((String)extendss[1]);
                }
                rankParents.put(currentRank.getID(), parent);
                continue;
            }
            if (currentRank != null) {
                String[] s2;
                JsonElement json;
                String[] s1 = line.split(":", 2);
                if (s1.length != 2 || JsonUtils.isNull((JsonElement)(json = DataReader.get((String)(s2 = s1[1].split(" //"))[0].trim()).safeJson()))) continue;
                currentRank.setPermission(Node.get((String)s1[0].trim()), json);
                continue;
            }
            result = false;
        }
        for (Rank rank : this.ranks.values()) {
            Rank rankp = this.getRank((String)rankParents.get(rank.getID()));
            if (rankp == rank) continue;
            rank.parent = rankp;
        }
        this.saveRanks();
        File playerRanksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.json");
        ranksJson = DataReader.get((File)playerRanksFile).safeJson();
        if (ranksJson.isJsonObject()) {
            for (Map.Entry entry : ranksJson.getAsJsonObject().entrySet()) {
                Rank rank;
                ForgePlayer player = this.universe.getPlayer((CharSequence)entry.getKey());
                if (player == null || (rank = this.getRank(((JsonElement)entry.getValue()).getAsString())).isNone()) continue;
                this.playerMap.put(player.getId(), rank);
            }
            FileUtils.deleteSafe((File)playerRanksFile);
        }
        playerRanksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.txt");
        for (String s : DataReader.get((File)playerRanksFile).safeStringList()) {
            Rank rank;
            ForgePlayer player;
            String[] s1;
            if (s.isEmpty() || s.startsWith("//") || (s1 = s.split(":", 2)).length != 2 || (player = this.universe.getPlayer((CharSequence)s1[0].trim())) == null || (rank = this.getRank(s1[1].trim())).isNone()) continue;
            this.playerMap.put(player.getId(), rank);
        }
        this.savePlayerRanks();
        return result;
    }

    public void saveRanks() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://www.curseforge.com/minecraft/mc-mods/ftb-utilities/pages/ranks");
        list.add("// To see the list of permission nodes, open all_permissions.html in browser or all_permissions_full_list.txt");
        StringBuilder line = new StringBuilder();
        for (Rank rank : this.ranks.values()) {
            list.add("");
            line.setLength(0);
            line.append('[');
            line.append((Object)rank);
            if (!rank.parent.isNone()) {
                line.append(" extends ");
                line.append((Object)rank.parent);
            }
            if (!rank.tags.isEmpty()) {
                line.append(" is ");
                line.append(StringJoiner.with((String)", ").join(rank.tags));
            }
            line.append(']');
            list.add(line.toString());
            for (Rank.Entry entry : rank.permissions) {
                list.add(entry.node + ": " + entry.json);
            }
        }
        FileUtils.saveSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/ranks.txt"), list);
    }

    public void clearCache() {
        this.rankNames = null;
        this.permissionNodes = null;
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        for (Rank rank : this.ranks.values()) {
            rank.cachedPermissions.clear();
            rank.cachedConfig.clear();
        }
    }

    public void savePlayerRanks() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://www.curseforge.com/minecraft/mc-mods/ftb-utilities/pages/ranks");
        list.add("");
        for (Map.Entry<UUID, Rank> entry : this.playerMap.entrySet()) {
            ForgePlayer player = this.universe.getPlayer(entry.getKey());
            if (player != null) {
                list.add(player + ": " + (Object)((Object)entry.getValue()));
                continue;
            }
            list.add(StringUtils.fromUUID((UUID)entry.getKey()) + ": " + (Object)((Object)entry.getValue()));
        }
        FileUtils.saveSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.txt"), list);
    }

    private String classOf(ConfigValue value) {
        if (value instanceof ConfigBoolean) {
            return value.getBoolean() ? "true" : "false";
        }
        return "other";
    }

    private String fixHTML(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public void generateExampleFiles() {
        ArrayList<NodeEntry> allNodes = new ArrayList<NodeEntry>(FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY);
        for (String s : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
            String desc = PermissionAPI.getPermissionHandler().getNodeDescription(s);
            Node node = Node.get((String)s);
            boolean printNode = true;
            for (NodeEntry cprefix : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                if (!cprefix.getNode().matches(node)) continue;
                if (cprefix.level == null || level != cprefix.level || !desc.isEmpty()) break;
                printNode = false;
                break;
            }
            if (!printNode) continue;
            allNodes.add(new NodeEntry(node, level, desc));
        }
        for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
            String desc = new TextComponentTranslation("permission." + info.node, new Object[0]).func_150260_c();
            allNodes.add(new NodeEntry(info.node, info.defaultValue, info.defaultOPValue, desc.equals(info.node.toString()) ? "" : desc, null));
        }
        allNodes.sort(null);
        ArrayList<String> list = new ArrayList<String>();
        list.add("<html><head><title>Permissions</title><style>");
        list.add("table{font-family:arial, sans-serif;border-collapse:collapse;}");
        list.add("td,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}");
        list.add("th{background-color:#CCCCCC;}");
        list.add("p{margin:0;}");
        list.add("tr:nth-child(even){background-color:#D8D8D8;}");
        list.add("tr:nth-child(odd){background-color:#EEEEEE;}");
        list.add("td.true{background-color:#72FF85AA;}");
        list.add("td.false{background-color:#FF6666AA;}");
        list.add("td.other{background-color:#42A3FFAA;}");
        list.add("td.error{color:#FF0000;}");
        list.add("th,td.true,td.false,td.other{text-align:center;}");
        list.add("</style></head><body><h1>Permissions</h1><h3>Modifying this file won't have any effect, edit ranks.txt!</h3><table>");
        list.add("<tr><th>Node</th><th>Type</th><th>Player</th><th>OP</th><th>Info (Mouse over for variants)</th></tr>");
        for (NodeEntry entry : allNodes) {
            list.add("<tr>");
            list.add("<td><code>" + entry.getNode() + "</code></td>");
            list.add("<td><code>" + entry.player.getID() + "</code></td>");
            String playerText = this.fixHTML(entry.player.getStringForGUI().func_150260_c());
            String opText = this.fixHTML(entry.op.getStringForGUI().func_150260_c());
            if (playerText.equals(opText)) {
                list.add("<td class='" + this.classOf(entry.player) + "' colspan='2'><code>" + playerText + "</code></td>");
            } else {
                list.add("<td class='" + this.classOf(entry.player) + "'><code>" + playerText + "</code></td>");
                list.add("<td class='" + this.classOf(entry.op) + "'><code>" + opText + "</code></td>");
            }
            list.add("<td title='");
            ArrayList<String> variants = new ArrayList<String>();
            if (entry.player instanceof ConfigBoolean) {
                variants.add("true");
                variants.add("false");
            } else if (entry.player instanceof ConfigInt) {
                int min = ((ConfigInt)entry.player).getMin();
                int max = ((ConfigInt)entry.player).getMax();
                variants.add(String.format("%s to %s", min == Integer.MIN_VALUE ? "-&infin;" : String.valueOf(min), max == Integer.MAX_VALUE ? "&infin;" : String.valueOf(max)));
            } else if (entry.player instanceof ConfigDouble) {
                double min = ((ConfigDouble)entry.player).getMin();
                double max = ((ConfigDouble)entry.player).getMax();
                variants.add(String.format("%s to %s", min == Double.NEGATIVE_INFINITY ? "-&infin;" : StringUtils.formatDouble((double)min), max == Double.POSITIVE_INFINITY ? "&infin;" : StringUtils.formatDouble((double)max)));
            } else if (entry.player instanceof ConfigTimer) {
                Ticks max = ((ConfigTimer)entry.player).getMax();
                variants.add(String.format("0s to %s", !max.hasTicks() ? "&infin;" : max.toString()));
            } else {
                variants = new ArrayList(entry.player.getVariants());
                variants.sort(StringUtils.IGNORE_CASE_COMPARATOR);
            }
            for (String s : variants) {
                list.add(StringUtils.unformatted((String)s) + " ");
            }
            list.add("'>");
            if (!entry.desc.isEmpty()) {
                for (Iterator<NodeEntry> iterator : entry.desc.split("\n")) {
                    list.add("<p>" + iterator + "</p>");
                }
            }
            list.add("</td></tr>");
        }
        list.add("</table><br><table><tr><th>Available command nodes</th><th>Usage</th></tr>");
        for (CommandOverride c : this.commands.values()) {
            String text = this.fixHTML(c.usage.func_150260_c()).replace(" OR ", "<br>");
            if (c.usage instanceof TextComponentString) {
                list.add("<tr><td><code>" + c.node + "</code></td><td class='error' title='Invalid usage language key!'>" + text + "</td></tr>");
                continue;
            }
            list.add("<tr><td><code>" + c.node + "</code></td><td>" + text + "</td></tr>");
        }
        list.add("</table>");
        list.add("</body></html>");
        FileUtils.saveSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/all_permissions.html"), list);
        FileUtils.deleteSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/all_configs.html"));
        list = new ArrayList();
        for (String node : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            list.add(node + ": " + DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node));
        }
        Collections.sort(list);
        list.add(0, PermissionAPI.getPermissionHandler().getRegisteredNodes().size() + " nodes in total");
        list.add(1, "Modifying this file won't have any effect, edit ranks.txt!");
        list.add(2, "");
        list.add("");
        list.add("Available command nodes:");
        list.add("");
        for (CommandOverride c : this.commands.values()) {
            list.add(c.node.toString());
        }
        FileUtils.saveSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/all_permissions_full_list.txt"), list);
    }
}

