/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManager {
    public static ClientTeamManager INSTANCE;
    public boolean invalid = false;
    private final UUID id;
    public final Map<UUID, ClientTeam> teamMap;
    public final Map<UUID, KnownClientPlayer> knownPlayers;
    public ClientTeam selfTeam;
    public KnownClientPlayer selfKnownPlayer;

    public ClientTeamManager(UUID i) {
        this.id = i;
        this.teamMap = new HashMap<UUID, ClientTeam>();
        this.knownPlayers = new HashMap<UUID, KnownClientPlayer>();
    }

    public ClientTeamManager(PacketBuffer buffer, long now) {
        this(buffer.func_179253_g());
        int ts = buffer.func_150792_a();
        for (int i = 0; i < ts; ++i) {
            ClientTeam t = new ClientTeam(this, buffer, now);
            this.teamMap.put(t.getId(), t);
        }
        int ps = buffer.func_150792_a();
        for (int i = 0; i < ps; ++i) {
            KnownClientPlayer knownClientPlayer = new KnownClientPlayer(buffer);
            this.knownPlayers.put(knownClientPlayer.uuid, knownClientPlayer);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void write(PacketBuffer buffer, long now) {
        buffer.func_179252_a(this.getId());
        buffer.func_150787_b(this.teamMap.size());
        for (ClientTeam t : this.teamMap.values()) {
            t.write(buffer, now);
        }
        buffer.func_150787_b(this.knownPlayers.size());
        for (KnownClientPlayer knownClientPlayer : this.knownPlayers.values()) {
            knownClientPlayer.write(buffer);
        }
    }

    public void init(UUID self, List<TeamMessage> messages) {
        this.selfTeam = this.teamMap.get(self);
        this.selfTeam.messageHistory.addAll(messages);
        this.selfKnownPlayer = this.knownPlayers.get(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
    }

    @Nullable
    public KnownClientPlayer getKnownPlayer(UUID id) {
        return this.knownPlayers.get(id);
    }

    @Nullable
    public ClientTeam getTeam(UUID id) {
        return this.teamMap.get(id);
    }

    public ITextComponent getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.field_240973_b_)) {
            return new StringTextComponent("System").func_240699_a_(TextFormatting.LIGHT_PURPLE);
        }
        KnownClientPlayer p = this.knownPlayers.get(id);
        return new StringTextComponent(p == null ? "Unknown" : p.name).func_240699_a_(TextFormatting.YELLOW);
    }
}

