/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import net.minecraft.util.Facing;

public enum SidedDirection {
    BOTTOM(2, 3, 0, 0, 0, 0),
    TOP(3, 2, 1, 1, 1, 1),
    BACK(1, 0, 3, 2, 5, 4),
    FRONT(0, 1, 2, 3, 4, 5),
    LEFT(4, 5, 5, 4, 2, 3),
    RIGHT(5, 4, 4, 5, 3, 2),
    NONE(6, 6, 6, 6, 6, 6);

    public final int[] directions;
    public final int ID;
    public static final SidedDirection[] VALUES;

    private SidedDirection(int ... i) {
        this.directions = i;
        this.ID = this.ordinal();
    }

    public static SidedDirection getSide(int side, int rot) {
        if (rot < 0 || rot >= 6 || side < 0 || side >= 6) {
            return NONE;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            if (SidedDirection.VALUES[i].directions[rot] != side) continue;
            return VALUES[i];
        }
        return NONE;
    }

    public static SidedDirection get(int side, int rot3D, int rot2D) {
        if (side == rot3D) {
            return FRONT;
        }
        if (side == Facing.field_71588_a[rot3D]) {
            return BACK;
        }
        if (rot3D == 0) {
            if (side == 2 || side == 3 || side == 4 || side == 5) {
                if (rot2D == side) {
                    return TOP;
                }
                if (rot2D == Facing.field_71588_a[side]) {
                    return BOTTOM;
                }
            }
            return SidedDirection.getSide(side, rot2D);
        }
        if (rot3D == 1) {
            if (side == 2 || side == 3 || side == 4 || side == 5) {
                if (rot2D == side) {
                    return BOTTOM;
                }
                if (rot2D == Facing.field_71588_a[side]) {
                    return TOP;
                }
            }
            return SidedDirection.getSide(side, rot2D);
        }
        if (side == 0) {
            return BOTTOM;
        }
        if (side == 1) {
            return TOP;
        }
        return SidedDirection.getSide(side, rot3D);
    }

    static {
        VALUES = new SidedDirection[]{BOTTOM, TOP, BACK, FRONT, LEFT, RIGHT};
    }
}

