/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class SelectImageScreen
extends ButtonListBaseScreen {
    private final ImageConfig imageConfig;
    private final ConfigCallback callback;
    private final List<ResourceLocation> images;

    public SelectImageScreen(ImageConfig i, ConfigCallback c) {
        this.imageConfig = i;
        this.callback = c;
        this.setTitle((ITextComponent)new StringTextComponent("Select Image"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.images = new ArrayList<ResourceLocation>();
        StringUtils.ignoreResourceLocationErrors = true;
        Collection<Object> textures = Collections.emptyList();
        try {
            textures = Minecraft.func_71410_x().func_195551_G().func_199003_a("textures", t -> t.endsWith(".png"));
        }
        catch (Exception ex) {
            FTBLibrary.LOGGER.error("A mod has broken resource preventing this list from loading: " + ex);
        }
        StringUtils.ignoreResourceLocationErrors = false;
        for (ResourceLocation resourceLocation : textures) {
            if (!ResourceLocation.func_217855_b((String)resourceLocation.toString())) {
                FTBLibrary.LOGGER.warn("Image " + resourceLocation + " has invalid path! Report this to author of '" + resourceLocation.func_110624_b() + "'!");
                continue;
            }
            if (!this.isValidImage(resourceLocation)) continue;
            this.images.add(resourceLocation);
        }
        this.images.sort(null);
    }

    public boolean allowNone() {
        return true;
    }

    public boolean isValidImage(ResourceLocation id) {
        return !id.func_110623_a().startsWith("textures/font/");
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.allowNone()) {
            panel.add(new SimpleTextButton(panel, (ITextComponent)new StringTextComponent("None"), Icon.EMPTY){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue("");
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
        for (final ResourceLocation res : this.images) {
            panel.add(new SimpleTextButton(panel, (ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent(res.func_110624_b()).func_240699_a_(TextFormatting.GOLD)).func_240702_b_(":").func_230529_a_((ITextComponent)new StringTextComponent(res.func_110623_a().substring(9, res.func_110623_a().length() - 4)).func_240699_a_(TextFormatting.YELLOW)), Icon.getIcon(res.toString())){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue(res.toString());
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

