/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftblibrary.FTBLibraryClient;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.misc.LoadingScreen;
import dev.ftb.mods.ftblibrary.util.ChainedBooleanSupplier;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class SidebarButton
implements Comparable<SidebarButton> {
    private static final BooleanSupplier NEI_NOT_LOADED = () -> !Platform.isModLoaded((String)"notenoughitems");
    public final ResourceLocation id;
    public final SidebarButtonGroup group;
    private Icon icon = Icon.EMPTY;
    private int x = 0;
    private boolean defaultConfig = true;
    private boolean configValue = true;
    private final List<String> clickEvents = new ArrayList<String>();
    private final List<String> shiftClickEvents = new ArrayList<String>();
    private final boolean loadingScreen;
    private ChainedBooleanSupplier visible = ChainedBooleanSupplier.TRUE;
    private Supplier<String> customTextHandler = null;
    private Consumer<List<String>> tooltipHandler = null;

    public SidebarButton(ResourceLocation _id, SidebarButtonGroup g, JsonObject json) {
        JsonElement e2;
        Iterator iterator;
        JsonElement j;
        this.group = g;
        this.id = _id;
        if (json.has("icon")) {
            this.icon = Icon.getIcon(json.get("icon"));
        }
        if (this.icon.isEmpty()) {
            this.icon = Icons.ACCEPT_GRAY;
        }
        if (json.has("click")) {
            j = json.get("click");
            iterator = (j.isJsonArray() ? j.getAsJsonArray() : Collections.singleton(j)).iterator();
            while (iterator.hasNext()) {
                e2 = (JsonElement)iterator.next();
                if (!e2.isJsonPrimitive()) continue;
                this.clickEvents.add(e2.getAsString());
            }
        }
        if (json.has("shift_click")) {
            j = json.get("shift_click");
            iterator = (j.isJsonArray() ? j.getAsJsonArray() : Collections.singleton(j)).iterator();
            while (iterator.hasNext()) {
                e2 = (JsonElement)iterator.next();
                if (!e2.isJsonPrimitive()) continue;
                this.shiftClickEvents.add(e2.getAsString());
            }
        }
        if (json.has("config")) {
            this.defaultConfig = this.configValue = json.get("config").getAsBoolean();
        }
        if (json.has("x")) {
            this.x = json.get("x").getAsInt();
        }
        if (json.has("requires_op") && json.get("requires_op").getAsBoolean()) {
            this.addVisibilityCondition(ClientUtils.IS_CLIENT_OP);
        }
        if (json.has("hide_with_nei") && json.get("hide_with_nei").getAsBoolean()) {
            this.addVisibilityCondition(NEI_NOT_LOADED);
        }
        if (json.has("required_mods")) {
            LinkedHashSet<String> requiredServerMods = new LinkedHashSet<String>();
            for (JsonElement e2 : json.get("required_mods").getAsJsonArray()) {
                requiredServerMods.add(e2.getAsString());
            }
            this.addVisibilityCondition(() -> {
                for (String s : requiredServerMods) {
                    if (Platform.isModLoaded((String)s)) continue;
                    return false;
                }
                return true;
            });
        }
        this.loadingScreen = json.has("loading_screen") && json.get("loading_screen").getAsBoolean();
    }

    public void addVisibilityCondition(BooleanSupplier supplier) {
        this.visible = this.visible.and(supplier);
    }

    public String getLangKey() {
        return "sidebar_button." + this.id.func_110624_b() + '.' + this.id.func_110623_a();
    }

    public String getTooltipLangKey() {
        return this.getLangKey() + ".tooltip";
    }

    public String toString() {
        return this.id.toString();
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        return o == this || o instanceof SidebarButton && this.id.equals((Object)((SidebarButton)o).id);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public boolean getDefaultConfig() {
        return this.defaultConfig;
    }

    public void onClicked(boolean shift) {
        if (this.loadingScreen) {
            new LoadingScreen((ITextComponent)new TranslationTextComponent(this.getLangKey())).openGui();
        }
        for (String event : shift && !this.shiftClickEvents.isEmpty() ? this.shiftClickEvents : this.clickEvents) {
            GuiHelper.BLANK_GUI.handleClick(event);
        }
    }

    public boolean isActuallyVisible() {
        return this.configValue && FTBLibraryClient.showButtons != 0 && this.isVisible();
    }

    public boolean isVisible() {
        return this.visible.getAsBoolean();
    }

    public boolean getConfig() {
        return this.configValue;
    }

    public void setConfig(boolean value) {
        this.configValue = value;
    }

    @Nullable
    public Supplier<String> getCustomTextHandler() {
        return this.customTextHandler;
    }

    public void setCustomTextHandler(Supplier<String> text) {
        this.customTextHandler = text;
    }

    @Nullable
    public Consumer<List<String>> getTooltipHandler() {
        return this.tooltipHandler;
    }

    public void setTooltipHandler(Consumer<List<String>> text) {
        this.tooltipHandler = text;
    }

    @Override
    public int compareTo(SidebarButton button) {
        return this.getX() - button.getX();
    }
}

