/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SelectItemStackScreen
extends BaseScreen {
    public static final ExecutorService ITEM_SEARCH = Executors.newSingleThreadExecutor(task -> {
        Thread thread = new Thread(task, "FTBLibrary-ItemSearch");
        thread.setDaemon(true);
        return thread;
    });
    public static final List<ItemSearchMode> modes = new ArrayList<ItemSearchMode>();
    private static ItemSearchMode activeMode;
    private final ItemStackConfig config;
    private final ConfigCallback callback;
    private ItemStack current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final Panel panelStacks;
    private final PanelScrollBar scrollBar;
    private final TextBox searchBox;
    private final Panel tabs;
    public long update = Long.MAX_VALUE;

    public List<Widget> getItems(String search, Panel panel) {
        Stopwatch timer = Stopwatch.createStarted();
        if (activeMode == null) {
            return Collections.emptyList();
        }
        Collection<ItemStack> items = activeMode.getAllItems();
        ArrayList<Widget> widgets = new ArrayList<Widget>(search.isEmpty() ? items.size() + 1 : 64);
        String mod = "";
        if (search.startsWith("@")) {
            mod = search.substring(1);
        }
        ItemStackButton button = new ItemStackButton(panel, ItemStack.field_190927_a);
        if (this.config.allowEmpty && button.shouldAdd(search, mod)) {
            widgets.add(new ItemStackButton(panel, ItemStack.field_190927_a));
        }
        for (ItemStack stack : items) {
            if (stack.func_190926_b() || !(button = new ItemStackButton(panel, stack)).shouldAdd(search, mod)) continue;
            widgets.add(button);
            int j = widgets.size() - 1;
            button.setPos(1 + j % 9 * 19, 1 + j / 9 * 19);
        }
        FTBLibrary.LOGGER.info("Done updating item list in {}\u03bcs!", (Object)timer.stop().elapsed(TimeUnit.MICROSECONDS));
        return widgets;
    }

    public SelectItemStackScreen(ItemStackConfig c, ConfigCallback cb) {
        this.setSize(211, 150);
        this.config = c;
        this.callback = cb;
        this.current = ((ItemStack)this.config.value).func_190926_b() ? ItemStack.field_190927_a : ((ItemStack)this.config.value).func_77946_l();
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, (ITextComponent)new TranslationTextComponent("gui.cancel"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.callback.save(false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, (ITextComponent)new TranslationTextComponent("gui.accept"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.config.setCurrentValue(SelectItemStackScreen.this.current);
                SelectItemStackScreen.this.callback.save(true);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.panelStacks = new BlankPanel(this){

            @Override
            public void addWidgets() {
                SelectItemStackScreen.this.update = System.currentTimeMillis() + 100L;
            }

            @Override
            public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(matrixStack, x, y, w, h);
            }
        };
        this.panelStacks.setPosAndSize(9, 24, 172, 96);
        this.scrollBar = new PanelScrollBar(this, this.panelStacks);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20.0);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                SelectItemStackScreen.this.panelStacks.refreshWidgets();
            }
        };
        this.searchBox.setPosAndSize(8, 7, this.width - 16, 12);
        this.searchBox.ghostText = I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]);
        this.searchBox.setFocused(true);
        this.tabs = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new ButtonSwitchMode(this));
                this.add(new ButtonEditData(this));
                if (!((SelectItemStackScreen)SelectItemStackScreen.this).config.singleItemOnly) {
                    this.add(new ButtonCount(this));
                }
                this.add(new ButtonNBT(this));
                this.add(new ButtonCaps(this));
            }

            @Override
            public void alignWidgets() {
                for (Widget widget : this.widgets) {
                    widget.setSize(20, 20);
                }
                this.setHeight(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.tabs.setPosAndSize(-19, 8, 20, 0);
        this.updateItemWidgets(Collections.emptyList());
    }

    private void updateItemWidgets(List<Widget> items) {
        this.panelStacks.widgets.clear();
        this.panelStacks.addAll(items);
        this.scrollBar.setPosAndSize(this.panelStacks.posX + this.panelStacks.width + 6, this.panelStacks.posY - 1, 16, this.panelStacks.height + 2);
        this.scrollBar.setValue(0.0);
        this.scrollBar.setMaxValue(1 + MathHelper.func_76123_f((float)((float)this.panelStacks.widgets.size() / 9.0f)) * 19);
    }

    @Override
    public void addWidgets() {
        this.add(this.tabs);
        this.add(this.panelStacks);
        this.add(this.scrollBar);
        this.add(this.searchBox);
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
    }

    @Override
    public void onClosed() {
        super.onClosed();
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        long now = System.currentTimeMillis();
        if (now >= this.update) {
            this.update = Long.MAX_VALUE;
            CompletableFuture.supplyAsync(() -> this.getItems(this.searchBox.getText().toLowerCase(), this.panelStacks), ITEM_SEARCH).thenAcceptAsync(this::updateItemWidgets, (Executor)Minecraft.func_71410_x());
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        Screen screen = this.getPrevScreen();
        return screen != null && screen.func_231177_au__();
    }

    static {
        modes.add(ItemSearchMode.ALL_ITEMS);
        modes.add(ItemSearchMode.INVENTORY);
        activeMode = null;
    }

    private class ButtonCaps
    extends ButtonStackConfig {
        public ButtonCaps(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("ftblibrary.select_item.caps"), ItemIcon.getItemIcon(Items.field_221844_ef));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            CompoundNBT nbt = SelectItemStackScreen.this.current.func_77955_b(new CompoundNBT());
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, (CompoundNBT)nbt.func_74781_a("ForgeCaps"), (CompoundNBT)((ItemStack)((SelectItemStackScreen)SelectItemStackScreen.this).config.defaultValue).func_77955_b(new CompoundNBT()).func_74781_a("ForgeCaps"), accepted -> {
                if (accepted) {
                    if (c.value == null || ((CompoundNBT)c.value).isEmpty()) {
                        nbt.func_82580_o("ForgeCaps");
                    } else {
                        nbt.func_218657_a("ForgeCaps", (INBT)c.value);
                    }
                    SelectItemStackScreen.this.current = ItemStack.func_199557_a((CompoundNBT)nbt);
                }
                SelectItemStackScreen.this.run();
            });
        }
    }

    private class ButtonNBT
    extends ButtonStackConfig {
        public ButtonNBT(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("ftblibrary.select_item.nbt"), ItemIcon.getItemIcon(Items.field_151057_cb));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.func_77978_p(), ((ItemStack)((SelectItemStackScreen)SelectItemStackScreen.this).config.defaultValue).func_77978_p(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.func_77982_d((CompoundNBT)c.value);
                }
                this.run();
            });
        }
    }

    private class ButtonCount
    extends ButtonStackConfig {
        public ButtonCount(Panel panel) {
            super(panel, (ITextComponent)new TranslationTextComponent("ftblibrary.select_item.count"), ItemIcon.getItemIcon(Items.field_151121_aF));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            IntConfig c = new IntConfig(0, SelectItemStackScreen.this.current.func_77976_d());
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.func_190916_E(), ((ItemStack)((SelectItemStackScreen)SelectItemStackScreen.this).config.defaultValue).func_190916_E(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.func_190920_e(((Integer)c.value).intValue());
                }
                this.run();
            });
        }
    }

    private class ButtonEditData
    extends Button {
        public ButtonEditData(Panel panel) {
            super(panel, StringTextComponent.field_240750_d_, Icons.BUG);
        }

        @Override
        public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            GuiHelper.drawItem(matrixStack, SelectItemStackScreen.this.current, x, y, (float)w / 16.0f, (float)h / 16.0f, true, null);
            matrixStack.func_227865_b_();
        }

        @Override
        public ITextComponent getTitle() {
            return SelectItemStackScreen.this.current.func_200301_q();
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.func_77955_b(new CompoundNBT()), ((ItemStack)((SelectItemStackScreen)SelectItemStackScreen.this).config.defaultValue).func_77955_b(new CompoundNBT()), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)c.value));
                }
                this.run();
            });
        }
    }

    private abstract class ButtonStackConfig
    extends Button {
        public ButtonStackConfig(Panel panel, ITextComponent title, Icon icon) {
            super(panel, title, icon);
        }

        @Override
        public WidgetType getWidgetType() {
            return SelectItemStackScreen.this.current.func_190926_b() ? WidgetType.DISABLED : super.getWidgetType();
        }
    }

    private class ButtonSwitchMode
    extends Button {
        private final Iterator<ItemSearchMode> modeIterator;

        public ButtonSwitchMode(Panel panel) {
            super(panel);
            this.modeIterator = Iterators.cycle(modes);
            activeMode = this.modeIterator.next();
        }

        @Override
        public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            activeMode.getIcon().draw(matrixStack, x, y, w, h);
        }

        @Override
        public ITextComponent getTitle() {
            return new TranslationTextComponent("ftblibrary.select_item.list_mode");
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            list.add((ITextComponent)activeMode.getDisplayName().func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" [" + ((SelectItemStackScreen)SelectItemStackScreen.this).panelStacks.widgets.size() + "]").func_240699_a_(TextFormatting.DARK_GRAY)));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            activeMode = this.modeIterator.next();
            SelectItemStackScreen.this.panelStacks.refreshWidgets();
        }
    }

    private class ItemStackButton
    extends Button {
        private final ItemStack stack;

        private ItemStackButton(Panel panel, ItemStack is) {
            super(panel, StringTextComponent.field_240750_d_, Icons.BARRIER);
            this.setSize(18, 18);
            this.stack = is;
            this.title = null;
            this.icon = ItemIcon.getItemIcon(is);
        }

        public boolean shouldAdd(String search, String mod) {
            if (search.isEmpty()) {
                return true;
            }
            if (!mod.isEmpty()) {
                return Registries.getId((Object)this.stack.func_77973_b(), (RegistryKey)Registry.field_239714_o_).func_110624_b().contains(mod);
            }
            return this.stack.func_200301_q().getString().toLowerCase().contains(search);
        }

        @Override
        public ITextComponent getTitle() {
            if (this.title == null) {
                this.title = this.stack.func_200301_q();
            }
            return this.title;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public WidgetType getWidgetType() {
            return this.stack.func_77973_b() == SelectItemStackScreen.this.current.func_77973_b() && Objects.equals(this.stack.func_77978_p(), SelectItemStackScreen.this.current.func_77978_p()) ? WidgetType.MOUSE_OVER : super.getWidgetType();
        }

        @Override
        public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(matrixStack, x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            SelectItemStackScreen.this.current = this.stack.func_77946_l();
        }
    }
}

